package de.fzi.wim.guibase.graphview.graph;

/**
 * The default implementation of the edge.
 */
public class DefaultEdge implements Edge {
    /** The node from the edge. */
    protected Node m_from;
    /** The node to the edge. */
    protected Node m_to;

    /**
     * Creates an instance of this class.
     *
     * @param from                  the node from
     * @param to                    the node to
     */
    public DefaultEdge(Node from,Node to) {
        m_from=from;
        m_to=to;
    }
    /**
     * Returns the node from which this edge points.
     *
     * @return                       the node from which this edge points
     */
    public Node getFrom() {
        return m_from;
    }
    /**
     * Returns the node from which to edge points.
     *
     * @return                       the node to which this edge points
     */
    public Node getTo() {
        return m_to;
    }
    /**
     * Returns the label of this node.
     *
     * @return                      the label of the node
     */
    public String getLabels() {
        return toString();
    }
    /**
     * Returns the length of this edge.
     *
     * @return                      the ledge of the edge
     */
    public double getLength() {
        return 40;
    }
}
