package de.fzi.wim.guibase.graphview.controller;

import java.beans.PropertyChangeSupport;
import java.awt.Point;
import java.awt.event.MouseEvent;

import de.fzi.wim.guibase.graphview.graph.*;
import de.fzi.wim.guibase.graphview.view.*;

/**
 * A manipulator that tracks the currently higlighted element.
 */
public class HighlightingManipulator extends AbstractManipulator {
    /** The name of this manipulator. */
    public static final String NAME="HighlightingManipulator";

    /** The support for property changes. */
    protected PropertyChangeSupport m_propertyChangeSupport;
    /** The node that is highlighted. */
    protected Node m_highlightedNode;
    /** The edge that is highlighted. */
    protected Edge m_highlightedEdge;

    /**
     * Creates an instance of this class.
     */
    public HighlightingManipulator() {
        m_propertyChangeSupport=new PropertyChangeSupport(this);
    }
    public String getName() {
        return NAME;
    }
    public Node getHighlightedNode() {
        return m_highlightedNode;
    }
    public void setHighlightedNode(Node highlightedNode) {
        if (highlightedNode!=m_highlightedNode) {
            Node oldHighlightedNode=m_highlightedNode;
            if (oldHighlightedNode!=null)
                m_graphPane.repaintNode(oldHighlightedNode);
            m_highlightedNode=highlightedNode;
            if (m_highlightedNode!=null)
                m_graphPane.repaintNode(m_highlightedNode);
            m_propertyChangeSupport.firePropertyChange("highlightedNode",oldHighlightedNode,m_highlightedNode);
        }
    }
    public Edge getHighlightedEdge() {
        return m_highlightedEdge;
    }
    public void setHighlightedEdge(Edge highlightedEdge) {
        if (highlightedEdge!=m_highlightedEdge) {
            Edge oldHighlightedEdge=m_highlightedEdge;
            if (oldHighlightedEdge!=null)
                m_graphPane.repaintEdge(oldHighlightedEdge);
            m_highlightedEdge=highlightedEdge;
            if (m_highlightedEdge!=null)
                m_graphPane.repaintEdge(m_highlightedEdge);
            m_propertyChangeSupport.firePropertyChange("highlightedEdge",oldHighlightedEdge,m_highlightedEdge);
        }
    }
    public void mouseEntered(MouseEvent e) {
        updateHighlight(e);
    }
    public void mouseExited(MouseEvent e) {
        setHighlightedNode(null);
        setHighlightedEdge(null);
    }
    public void mouseDragged(MouseEvent e) {
        updateHighlight(e);
    }
    public void mouseMoved(MouseEvent e) {
        updateHighlight(e);
    }
    protected void updateHighlight(MouseEvent e) {
        if (m_graphPane.isEnabled()) {
            Point point=e.getPoint();
            Node nodeAtPoint=m_graphPane.getNodeAtPoint(point);
            if (nodeAtPoint!=null) {
                setHighlightedNode(nodeAtPoint);
                setHighlightedEdge(null);
            }
            else {
                setHighlightedNode(null);
                Edge edgeAtPoint=m_graphPane.getNearestEdge(point);
                setHighlightedEdge(edgeAtPoint);
            }
        }
        else {
            setHighlightedNode(null);
            setHighlightedEdge(null);
        }
    }
}
