package de.fzi.wim.guibase.graphview.controller;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Cursor;
import java.awt.event.MouseEvent;

import de.fzi.wim.guibase.graphview.view.*;

/**
 * A manipulator enabling the dragging of the graph's background.
 */
public class BackgroundDraggingManipulator extends AbstractManipulator {
    /** The name of this manipulator. */
    public static final String NAME="BackgroundDraggingManipulator";

    /** The position where the mouse was grabbed. */
    protected Point m_grabPosition;
    /** The original cursor of the graph. */
    protected Cursor m_graphCursor;

    /**
     * Creates an instance of this class.
     */
    public BackgroundDraggingManipulator() {
    }
    public String getName() {
        return NAME;
    }
    public boolean isDragging() {
        return m_grabPosition!=null;
    }
    public void mousePressed(MouseEvent e) {
        if (m_graphPane.isEnabled() && (e.getModifiers() & MouseEvent.BUTTON1_MASK)!=0 && isStartBackgroundDraggingEvent(e)) {
            Point point=e.getPoint();
            if (m_graphPane.getNodeAtPoint(point)==null && m_graphPane.getNearestEdge(point)==null) {
                m_grabPosition=point;
                m_graphCursor=m_graphPane.getCursor();
                m_graphPane.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
                e.consume();
            }
        }
    }
    public void mouseReleased(MouseEvent e) {
        if (isDragging()) {
            performDrag(e.getPoint());
            m_graphPane.setCursor(m_graphCursor);
            m_graphCursor=null;
            m_grabPosition=null;
            e.consume();
        }
    }
    public void mouseDragged(MouseEvent e) {
        if (isDragging()) {
            performDrag(e.getPoint());
            e.consume();
        }
    }
    protected void performDrag(Point position) {
        Rectangle rectangle=m_graphPane.getVisibleRect();
        rectangle.x+=m_grabPosition.x-position.x;
        rectangle.y+=m_grabPosition.y-position.y;
        m_graphPane.scrollRectToVisible(rectangle);
        m_grabPosition=position;
    }
    protected boolean isStartBackgroundDraggingEvent(MouseEvent e) {
        return (e.getModifiers() & MouseEvent.SHIFT_MASK)!=0;
    }
}
