package de.fzi.wim.guibase.dnd;

import java.util.Collection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.UnsupportedFlavorException;

/**
 * Selection that is capable of transfering intra-JVM a collection of objects.
 */
public class CollectionSelection implements Transferable,ClipboardOwner {
    /** Data flavor for object selections. */
    public static final DataFlavor s_objectCollectionFlavor=new DataFlavor(DataFlavor.javaJVMLocalObjectMimeType,"Object Collection");
    /** Array of supported flavors. */
    protected static final DataFlavor[] s_flavors=new DataFlavor[] { s_objectCollectionFlavor };

    /** Object collection being transfered. */
    protected Collection m_collection;

    /**
     * Creates a selection object.
     *
     * @param collection                collection being transfered
     */
    public CollectionSelection(Collection collection) {
        m_collection=collection;
    }
    /**
     * Returns the flavors of this transferable object.
     *
     * @return                          array of flavors of this transferable object
     */
    public DataFlavor[] getTransferDataFlavors() {
    	return (DataFlavor[])s_flavors.clone();
    }
    /**
     * Returns whether the requested flavor is supported by this Transferable.
     *
     * @param                           flavor the requested flavor for the data
     * @return                          <code>true if flavor is equal to <code>s_objectCollectionFlavor</code>
     */
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return s_objectCollectionFlavor.equals(flavor);
    }
    /**
     * Returns data of this transferable.
     *
     * @param                           flavor the requested flavor for the data
     * @return                          the data in the requested flavor, as outlined above
     * @throws                          UnsupportedFlavorException if the requested data flavor is equal to <code>s_objectCollectionFlavor</code>
     */
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
    	if (s_objectCollectionFlavor.equals(flavor))
    	    return m_collection;
        else
            throw new UnsupportedFlavorException(flavor);
    }
    /**
     * Called when this object doesn't own clipboard any more.
     */
    public void lostOwnership(Clipboard clipboard,Transferable contents) {
    }
}
