package de.fzi.wim.guibase.dnd;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.UIManager;

import de.fzi.wim.guibase.tables.*;

/**
 * Viewport that paints a border arund viewport if needed.
 */
public class BorderedViewport extends ViewportWithText {
    /** Color of the viewport border. */
    protected Color m_viewportBorderColor;
    /** Set to <code>true</code> if border should be shown. */
    protected boolean m_borderShown;

    /**
     * Updates the UI.
     */
    public void updateUI() {
        super.updateUI();
        m_viewportBorderColor=UIManager.getColor("Table.gridColor");
        m_borderShown=false;
    }
    /**
     * Determines if border is shown.
     *
     * @param borderShown               determines if border is shown
     */
    public void setBorderShown(boolean borderShown) {
        if (m_borderShown!=borderShown) {
            boolean oldValue=m_borderShown;
            m_borderShown=borderShown;
            firePropertyChange("borderShown",oldValue,m_borderShown);
            repaint();
        }
    }
    /**
     * Returns wherher border is shown.
     *
     * @return                          <code>true</code> if border is shown
     */
    public boolean getBorderShown() {
        return m_borderShown;
    }
    /**
     * Paints the viewport.
     *
     * @param g                         the graphics object
     */
    public void paint(Graphics g) {
        super.paint(g);
        if (m_borderShown) {
            g.setColor(m_viewportBorderColor);
            int width=getWidth();
            int height=getHeight();
            for (int i=0;i<2;i++) {
                g.drawLine(0,i,width-1,i);
                g.drawLine(0,height-i-1,width-1,height-i-1);
            }
            for (int i=0;i<2;i++) {
                g.drawLine(i,0,i,height-1);
                g.drawLine(width-i-1,0,width-i-1,height-1);
            }
        }
    }
}
