package de.fzi.wim.guibase.command;

import java.util.EventListener;

/**
 * Listener on the command manager.
 */
public interface CommandManagerListener extends EventListener {
    /**
     * Notifies the listener that the asynchronous command started to be executed.
     *
     * @param commandManager                        the command manager
     * @param command                               the command
     * @param executionType                         1 - execute, 2 - undo, 3 - redo was called
     */
    void commandWillExecute(CommandManager commandManager,Command command,int executionType);
    /**
     * Notifies the listener that the asynchronous command has been executed.
     *
     * @param commandManager                        the command manager
     * @param command                               the command
     * @param executionType                         1 - execute, 2 - undo, 3 - redo was called
     */
    void commandExecuted(CommandManager commandManager,Command command,int executionType);
    /**
     * Notifies the listener that an error occured during execution of the asynchronous command.
     *
     * @param commandManager                        the command manager
     * @param command                               the command
     * @param commandException                      the execption
     */
    void commandException(CommandManager commandManager,Command command,CommandException commandException);
    /**
     * Notifies the listener that the availability of the undo-redo operations changed.
     *
     * @param commandManager                        the command manager
     * @param canUndo                               determines whether the command manager can undo the comman
     * @param canRedo                               determines whether the command manager can redo the comman
     */
    void undoRedoAvailabilityChanged(CommandManager commandManager,boolean canUndo,boolean canRedo);
}
