package de.fzi.wim.guibase.command;

/**
 * An interface for all commands in the system using which the system implements
 * the 'Command' design pattern.
 */
public interface Command {
    /**
     * Returns <code>true</code> if this command should be executed asynchronously.
     *
     * @return                          <code>true</code> if this command should be executed asynchronously
     */
    boolean executeAsynchronously();
    /**
     * Executes the command.
     *
     * @throws CommandException         thrown if the command cannot be executed
     */
    void execute() throws CommandException;
}
