package de.fzi.wim.guibase.classfactory;

import java.lang.reflect.Constructor;
import org.w3c.dom.Node;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/**
 * Provides means to create classes indirectly from an XML configuration file.
 */
public class ClassFactory {
    /** The root of the factory configuration. */
    protected Element m_root;

    /**
     * Creates an instance of this class.
     *
     * @param document                  the configuration document
     */
    public ClassFactory(Document document) {
        NodeList factoryRootList=document.getElementsByTagName("classfactory");
        if (factoryRootList.getLength()>0)
            m_root=(Element)factoryRootList.item(0);
    }
    /**
     * Returns the class name for given element ID and returns <code>null</code> if there is no such element.
     *
     * @param elementID                 the ID of the element
     * @return                          the name of the class for given element (<code>null</code> if element with given name does not exist)
     */
    public String getElementClassName(String elementID) {
        if (m_root!=null) {
            NodeList children=m_root.getChildNodes();
            for (int i=0;i<children.getLength();i++) {
                Node childNode=children.item(i);
                if (childNode instanceof Element) {
                    Element childElement=(Element)childNode;
                    if (elementID.equals(childElement.getAttribute("elementID")))
                        return childElement.getAttribute("className");
                }
            }
        }
        return null;
    }
    /**
     * Creates a class for given element.
     *
     * @param elementID                 the ID of the element
     * @return                          the class for given element
     * @throws ClassNotFoundException   thrown if the class cannot be found
     */
    public Class getElementClass(String elementID) throws ClassNotFoundException {
        String className=getElementClassName(elementID);
        if (className==null)
            className=elementID;
        return Class.forName(className);
    }
    /**
     * Creates an object for given element.
     *
     * @param elementID                 the ID of the element
     * @return                          the object for given element
     * @throws Exception                thrown if there is a problem with initialization
     */
    public Object createElement(String elementID) throws Exception {
        return getElementClass(elementID).newInstance();
    }
    /**
     * Creates an object for given element and given parameters.
     *
     * @param elementID                 the ID of the element
     * @param parameters                the array of paramters
     * @return                          the object for given element
     * @throws Exception                thrown if there is a problem with initialization
     */
    public Object createElement(String elementID,Object[] parameters) throws Exception {
        Class[] parameterTypes=new Class[parameters.length];
        for (int i=0;i<parameters.length;i++)
            if (parameters[i]!=null)
                parameterTypes[i]=parameters[i].getClass();
        Class clazz=getElementClass(elementID);
        Constructor constructor=clazz.getDeclaredConstructor(parameterTypes);
        return constructor.newInstance(parameters);
    }
}
