package de.fzi.wim.guibase.appdriver;

import java.awt.Point;
import java.awt.Dimension;

/**
 * Interface describing a place where an object implementing {@link Viewable} interface can be embedded.
 */
public interface ViewableAnchor {
    /**
     * Disposes of the anchor.
     */
    void dispose();
    /**
     * Makes the anchor visible.
     *
     * @param visible                           <code>true</code> if anchor needs to be made visible
     */
    void setVisible(boolean visible);
    /**
     * Activates this anchor.
     */
    void activate();
    /**
     * Sets the title of this viewable anchor.
     *
     * @param title                             new title of the viewable frame
     */
    void setTitle(String title);
    /**
     * Returns the title of this viewable anchor.
     *
     * @return                                  the title of this viewable anchor
     */
    String getTitle();
    /**
     * Returns the current location.
     *
     * @return                                  the current location
     */
    Point getLocation();
    /**
     * Sets the location of the anchor.
     *
     * @param x                                 the x coordinate
     * @param y                                 the y coordinate
     */
    void setLocation(int x,int y);
    /**
     * Sets the location of the anchor.
     *
     * @param location                          the location
     */
    void setLocation(Point location);
    /**
     * Returns the current size.
     *
     * @return                                  the current size
     */
    Dimension getSize();
    /**
     * Sets the new size.
     *
     * @param width                             the new width
     * @param height                            the new height
     */
    void setSize(int width,int height);
    /**
     * Sets the new size.
     *
     * @param size                              the size
     */
    void setSize(Dimension size);
}
