package de.fzi.wim.guibase.appdriver;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JToolBar;

/**
 * This is the main class that start the application within the MDI setting.
 */
public class MultiAppDriver extends AppDriver {
    /** The main frame of the application. */
    protected MultiMainFrame m_mainFrame;

    /**
     * Creates an instance of this class.
     */
    public MultiAppDriver() {
    }
    /**
     * Creates the main frame window.
     */
    protected void createMainFrameWindow() {
        m_mainFrame=new MultiMainFrame(this);
        m_mainFrame.addWindowListener(new WindowAdapter() {
            public void windowActivated(WindowEvent e) {
                m_actions.updateActions();
            }
            public void windowClosing(WindowEvent e) {
                m_actions.invokeAction("action.guibase.exit",this,null);
            }
        });
        m_mainFrame.addPropertyChangeListener(new FramePropertyChangeHandler());
    }
    /**
     * Sets the toolbar to the main window.
     *
     * @param toolBar                           the toolbar to set
     */
    protected void setMainFrameToolBar(JToolBar toolBar) {
        m_mainFrame.setToolBar(toolBar);
    }
    /**
     * Returns the main application frame window.
     *
     * @return                                  main application frame window
     */
    public JFrame getMainFrameWindow() {
        return m_mainFrame;
    }
    /**
     * Creates a new viewable window.
     *
     * @param viewable                          viewable pane for which the window is creataed
     * @return                                  anchor within which the viewable was placed
     */
    protected ViewableAnchor createViewableAncor(Viewable viewable) {
        return m_mainFrame.newViewableAncor(viewable);
    }
    /**
     * Returns the currently selected viewable.
     *
     * @return                                  currently selected viewable
     */
    public Viewable getSelectedViewable() {
        return m_mainFrame.getSelectedViewable();
    }
    /**
     * Returns the current list of viewables.
     *
     * @return                                  the current list of viewables
     */
    public List getViewables() {
        return m_mainFrame.getViewables();
    }
    /**
     * Called when the application is exiting.
     */
    protected void applicationExiting() {
        m_mainFrame.applicationExiting();
        super.applicationExiting();
    }

    /**
     * Class that handles property changes on the main frame.
     */
    protected class FramePropertyChangeHandler implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent event) {
            if (event.getSource()==m_mainFrame && MultiMainFrame.SELECTED_VIEWABLE_PROPERTY.equals(event.getPropertyName())) {
                Viewable oldViewable=m_selectedViewable;
                m_selectedViewable=m_mainFrame.getSelectedViewable();
                m_propertyChangeSupport.firePropertyChange(SELECTED_VIEWABLE_PROPERTY,oldViewable,m_selectedViewable);
                m_actions.updateActions();
            }
        }
    }
}
