package de.fzi.wim.guibase.appdriver;

import de.fzi.wim.guibase.configuration.Configuration;
import de.fzi.wim.guibase.actions.SmartActionMap;

/**
 * A module interface implemented by all modules in the GUI.
 */
public interface Module {
    /**
     * Returns the name of the localization resource that should be loaded for this module.
     * Note that this method will be called before <code>setAppDriver()</code>. Therefore,
     * the module should not assume that the environment has been set up.
     *
     * @return                              the name of the localization resource or <code>null</code>
     */
    String getLocalizationResourceName();
    /**
     * Sets the application driver of the module.
     *
     * @param appDriver                     application driver
     */
    void setAppDriver(AppDriver appDriver);
    /**
     * Returns the application driver of this module.
     *
     * @return                              application driver
     */
    AppDriver getAppDriver();
    /**
     * Returns the name of the module.
     *
     * @return                              the name of this module
     */
    String getModuleName();
    /**
     * Returns the action map of the module.
     *
     * @return                              the action map of this module
     */
    SmartActionMap getSmartActionMap();
    /**
     * Called to restore the saved UI state of the viewable.
     *
     * @param configuration                 the configuration
     */
    void restoreUIState(Configuration configuration);
    /**
     * Checks whether the application can terminate.
     *
     * @return                              <code>true</code> if application can terminate
     */
    boolean canExitApplication();
    /**
     * Notifies the module that the application is exiting.
     */
    void applicationExiting();
}
