package de.fzi.wim.guibase.appdriver;

import de.fzi.wim.guibase.actions.SmartAction;
import de.fzi.wim.guibase.actions.SmartActionMap;
import de.fzi.wim.guibase.actions.SmartActionHashMap;
import de.fzi.wim.guibase.configuration.Configuration;

/**
 * A useful base class for all modules.
 */
public abstract class AbstractModule implements Module {
    /** Application driver. */
    protected AppDriver m_appDriver;
    /** Map of actions provided by this module. */
    protected SmartActionMap m_smartActionMap;

    /**
     * Sets the application driver of the module.
     *
     * @param appDriver                     application driver
     */
    public void setAppDriver(AppDriver appDriver) {
        m_appDriver=appDriver;
        m_smartActionMap=new SmartActionHashMap(null);
    }
    /**
     * Returns the application driver of this module.
     *
     * @return                              application driver
     */
    public AppDriver getAppDriver() {
        return m_appDriver;
    }
    /**
     * Returns the action map of the module.
     *
     * @return                              the action map of this module
     */
    public SmartActionMap getSmartActionMap() {
        return m_smartActionMap;
    }
    /**
     * Called to restore the saved UI state of the viewable.
     *
     * @param configuration                 the configuration
     */
    public void restoreUIState(Configuration configuration) {
    }
    /**
     * Checks whether the application can terminate.
     *
     * @return                              <code>true</code> if application can terminate
     */
    public boolean canExitApplication() {
        return true;
    }
    /**
     * Notifies the module that the application is exiting.
     */
    public void applicationExiting() {
    }
    /**
     * Adds an action to the action map.
     *
     * @param smartAction                   smart action to be added
     */
    protected void addAction(SmartAction smartAction) {
        m_smartActionMap.put(smartAction.getActionID(),smartAction);
    }
}
