package de.fzi.wim.guibase.actions;

import java.awt.event.ActionEvent;
import java.util.Map;

/**
 * Map of {@link SmartAction} objects.
 */
public interface SmartActionMap extends Map {
    /**
     * Invokes an application action with given ID.
     *
     * @param actionID              if of the action to be invoked
     * @param event                 action event object
     */
    void invokeAction(String actionID,ActionEvent event);
    /**
     * Invokes an application action with given ID.
     *
     * @param actionID              if of the action to be invoked
     * @param source                source of the event
     * @param command               command of the event
     */
    void invokeAction(String actionID,Object source,String command);
    /**
     * Updates all actions in the action map.
     */
    void updateActions();
    /**
     * Returns the action with given ID.
     *
     * @param actionID              ID of the action to be returned
     * @return                      action for given ID
     */
    SmartAction getAction(String actionID);
    /**
     * Returns the parent action map.
     *
     * @return                      the parent action map
     */
    SmartActionMap getParentSmartActionMap();
}
