package de.fzi.wim.guibase.actions;

import java.util.HashMap;
import java.util.Iterator;
import java.awt.event.ActionEvent;

/**
 * Action map that uses hash map as the map implementation.
 */
public class SmartActionHashMap extends HashMap implements SmartActionMap {
    /** The parent smart action map. */
    protected SmartActionMap m_parentSmartActionMap;
    /**
     * Creates this object.
     *
     * @param parentSmartActionMap  the parent action map
     */
    public SmartActionHashMap(SmartActionMap parentSmartActionMap) {
        m_parentSmartActionMap=parentSmartActionMap;
    }
    /**
     * Invokes an application action with given ID.
     *
     * @param actionID              if of the action to be invoked
     * @param event                 action event object
     */
    public void invokeAction(String actionID,ActionEvent event) {
        SmartAction action=getAction(actionID);
        if (action==null)
            throw new IllegalArgumentException("Unknown action with action ID '"+actionID+"'");
        action.updateAction();
        if (action.isEnabled())
            action.actionPerformed(event);
    }
    /**
     * Invokes an application action with given ID.
     *
     * @param actionID              if of the action to be invoked
     * @param source                source of the event
     * @param command               command of the event
     */
    public void invokeAction(String actionID,Object source,String command) {
        invokeAction(actionID,new ActionEvent(source,0,command));
    }
    /**
     * Updates all actions in the action map.
     */
    public void updateActions() {
        Iterator actions=values().iterator();
        while (actions.hasNext()) {
            SmartAction action=(SmartAction)actions.next();
            action.updateAction();
        }
        if (m_parentSmartActionMap!=null)
            m_parentSmartActionMap.updateActions();
    }
    /**
     * Returns the action with given ID.
     *
     * @param actionID              ID of the action to be returned
     * @return                      action for given ID
     */
    public SmartAction getAction(String actionID) {
        SmartAction action=(SmartAction)get(actionID);
        if (action==null && m_parentSmartActionMap!=null)
            action=m_parentSmartActionMap.getAction(actionID);
        return action;
    }
    /**
     * Returns the parent action map.
     *
     * @return                      the parent action map
     */
    public SmartActionMap getParentSmartActionMap() {
        return m_parentSmartActionMap;
    }
    /**
     * Adds an action to this map.
     *
     * @param action                action to be added
     */
    protected void addAction(SmartAction action) {
        put(action.getActionID(),action);
    }
}
