package de.fzi.wim.guibase.actions;

import java.util.List;
import java.util.ArrayList;

import de.fzi.wim.guibase.localization.LocalizationManager;

/**
 * An implementation of <code>SmartAction</code> interface that acts on behalf of a set of actions.
 * This action forwards all events to the actions of the aggregate manager.
 */
public class SmartActionAggregate extends SmartActionDecorator {

    /** The manager of this action. */
    protected SmartActionManager m_smartActionManager;
    /** List of actions that this action aggregates. */
    protected List m_smartActions;

    /**
     * Creates and initializes an instance of this class.
     *
     * @param actionID                          ID of this action
     * @param smartActionManager                the manager for actions
     * @param localizationManager               the localization manager
     */
    public SmartActionAggregate(String actionID,SmartActionManager smartActionManager,LocalizationManager localizationManager) {
        super(actionID,localizationManager);
        m_smartActionManager=smartActionManager;
        m_smartActions=new ArrayList();
    }
    /**
     * Returns the decorated action.
     *
     * @return                              decorated action
     */
    protected SmartAction getDecoratedAction() {
        SmartActionMap smartActionMap=m_smartActionManager.getCurrentAggregateActionMap();
        if (smartActionMap!=null)
            for (int i=0;i<m_smartActions.size();i++) {
                SmartAction smartAction=(SmartAction)m_smartActions.get(i);
                if (smartActionMap.getAction(smartAction.getActionID())!=null)
                    return smartAction;
            }
        return null;
    }
    /**
     * Adds an action to this aggregate.
     *
     * @param smartAction                   action to add
     */
    public void addAction(SmartAction smartAction) {
        m_smartActions.add(smartAction);
    }
}
