package de.fzi.wim.guibase.actions;

import javax.swing.Action;
import javax.swing.event.PopupMenuListener;

/**
 * Provides useful functionality over simple Swing action implementation. This functionality includes support for:
 * <ul>
 *	<li>Bundling the predicate that defines action state (enabled state, name, etc.) with the action. All that is needed to
 *	    synchronize the action with the state of the application is to call {@link #updateAction} method. One doesn't need
 *	    to worry when the predicate needs to be called, since an action can be registered as a popup menu listener and will
 *	    update itself when menu is being opened.
 *	<li>Action can be registered as the idle time listener so that it updates itself whenever the system is idle.
 *	<li>Action has a special parameter called <i>action ID</i> that is used to identify an action in the action map.
 * </ul>
 * <p>It is recommended to use <code>SmartAction</code> instead of <code>AbstractAction</code> as the base class for all
 * action implementations in the system.
 */
public interface SmartAction extends Action,PopupMenuListener {
	/** A constant defining the action ID key under which action IDs are stored. */
	final String ACTION_ID="actionID";
    /** Selected property. */
    final String SELECTED="selected";
    /** A constant defining the enabled property of the action. */
    final String ENABLED="enabled";

    /**
     * Returns the action ID of this action.
     *
     * @return                              action ID of this action
     */
    String getActionID();
	/**
	 * Should be overridden to provide the predicate for computing the state of the action. State might include updating
	 * enabled state of the icon, but might also include update the name (e.g. based on the current selection).
	 * Default implementation does nothing.
	 */
	void updateAction();
    /**
     * Returns whether this action is selected.
     *
     * @return                              <code>true</code> if this action is selected
     */
    boolean isSelected();
    /**
     * Sets the selected property of the action.
     *
     * @param selected                      selected property
     */
    void setSelected(boolean selected);
}
