package de.fzi.wim.guibase.actions;

import java.util.Comparator;

/**
 * An action that is modal - that can process different requests.
 */
public interface ModalSmartAction extends SmartAction {
    /**
     * Returns the array of modal options and their labels.
     *
     * @return                              the array of the form { modal option, option label } - should be <code>null</code> if the action is disabled
     */
    String[][] getModalOptions();
    /**
     * Checks whether given option is selected.
     *
     * @param optionIndex                   the index of the option
     * @return                              <code>true</code> if the option is selected
     */
    boolean isOptionSelected(int optionIndex);

    /**
     * The comparator for the options sorting them by the label.
     */
    final Comparator BY_LABEL_OPTIONS_COMPARATOR=new Comparator() {
        public int compare(Object o1,Object o2) {
            String[] item1=(String[])o1;
            String[] item2=(String[])o2;
            return item1[1].compareTo(item2[1]);
        }
    };
}
