package edu.unika.aifb.kaon.engineeringserver.query;

import java.util.Set;
import java.util.Iterator;
import java.sql.Connection;
import java.sql.Statement;
import java.sql.ResultSet;
import java.sql.SQLException;

import edu.unika.aifb.kaon.datalog.program.*;

import edu.unika.aifb.kaon.query.compiler.*;

/**
 * Implements the compilation of queries to datalog on the engineering server.
 */
public class ServerExpressionToDatalogCompiler extends ExpressionToDatalogCompiler {
    /** The ID of the model. */
    protected int m_modelID;
    /** The connection to the database. */
    protected Connection m_connection;

    /**
     * Creates an instance of this class.
     *
     * @param predicateFactory                      the factory for the program predicates
     * @param modelID                               the ID of the model
     * @param connection                            the connection to the database
     */
    public ServerExpressionToDatalogCompiler(PredicateFactory predicateFactory,int modelID,Connection connection) {
        super(predicateFactory);
        m_modelID=modelID;
        m_connection=connection;
    }
    /**
     * Creates a constant for the entity URI.
     *
     * @param entityURI                             the URI of the entity
     * @return                                      the constant for the entity URI
     */
    protected Constant entityURIConstant(String entityURI) {
        return new Constant(new EntityURI(entityURI));
    }
    /**
     * Retrieves the types of supplied properties.
     *
     * @param propertyNames                         the set of property names
     * @throws CompilationException                 thrown if there is an error
     */
    protected void loadPropertyTypes(Set propertyNames) throws CompilationException {
        StringBuffer buffer=new StringBuffer();
        buffer.append("SELECT entityURI,isAttribute FROM OIModelEntity WHERE modelID IN (SELECT includedModelID FROM AllIncludedOIModels WHERE includingModelID=");
        buffer.append(m_modelID);
        buffer.append(") AND entityURI IN (");
        Iterator iterator=propertyNames.iterator();
        while (iterator.hasNext()) {
            buffer.append('\'');
            buffer.append(iterator.next().toString());
            buffer.append('\'');
            if (iterator.hasNext())
                buffer.append(',');
        }
        buffer.append(')');
        String query=buffer.toString();
        Statement statement=null;
        ResultSet resultSet=null;
        try {
            statement=m_connection.createStatement();
            resultSet=statement.executeQuery(query);
            while (resultSet.next()) {
                String propertyName=resultSet.getString(1);
                boolean isAttribute=resultSet.getBoolean(2);
                m_propertyTypes.put(propertyName,isAttribute ? Boolean.TRUE : Boolean.FALSE);
            }
        }
        catch (SQLException error) {
            throw new CompilationException("SQL error",error);
        }
        finally {
            if (statement!=null)
                try {
                    statement.close();
                }
                catch (SQLException ignored) {
                }
            if (resultSet!=null)
                try {
                    resultSet.close();
                }
                catch (SQLException ignored) {
                }
        }
    }
}
