package edu.unika.aifb.kaon.engineeringserver.query;

/**
 * Encapsulates the URI for the entity. An object of this type is returned in tuples whenever an entity is referenced.
 */
public class EntityURI implements Comparable {
    /** The URI of the entity. */
    protected String m_entityURI;

    /**
     * Creates an instance of this class.
     *
     * @param entityURI                         the URI of the entity
     */
    public EntityURI(String entityURI) {
        m_entityURI=entityURI;
    }
    /**
     * Retrurns the URI of the entity.
     *
     * @return                                  the URI of the entity
     */
    public String getEntityURI() {
        return m_entityURI;
    }
    /**
     * Converts this object to string.
     *
     * @return                                  the string representation of this object
     */
    public String toString() {
        return m_entityURI;
    }
    /**
     * Checks whether two URIs are equal.
     *
     * @param that                              the other URI
     * @return                                  <code>true</code> if this and that URIs are equal
     */
    public boolean equals(Object that) {
        if (this==that)
            return true;
        if (!(that instanceof EntityURI))
            return false;
        String otherEntityURI=((EntityURI)that).getEntityURI();
        return m_entityURI==otherEntityURI || (m_entityURI!=null && m_entityURI.equals(otherEntityURI));
    }
    /**
     * Returns the hash-code of this object.
     *
     * @return                                  the hash-code of this object
     */
    public int hashCode() {
        return m_entityURI==null ? 0 : m_entityURI.hashCode();
    }
    /**
     * Compares two URIs.
     *
     * @param that                              the URI to compare with
     * @return                                  the code specifying which URI is first
     */
    public int compareTo(Object that) {
        String otherEntityURI=((EntityURI)that).getEntityURI();
        if (m_entityURI==otherEntityURI)
            return 0;
        else if (m_entityURI==null)
            return -1;
        else if (otherEntityURI==null)
            return 1;
        else
            return m_entityURI.compareTo(otherEntityURI);
    }
}
