package edu.unika.aifb.kaon.engineeringserver.query;

import edu.unika.aifb.kaon.api.vocabulary.*;

import edu.unika.aifb.kaon.datalog.magic.*;
import edu.unika.aifb.kaon.datalog.program.*;

/**
 * This SIPS implements several optimizations for engineering server that make query answering better. This is currently
 * a hack until I don't implement some good SIPS optimization strategy.
 */
public class EngineeringServerSIPS extends StandardSIPS {
    public static final SIPS INSTANCE=new EngineeringServerSIPS();

    /**
     * Compute the goodness of the bindings in a literal.
     *
     * @param literal                               the literal for which the goodness is computed
     * @param boundVariables                        the variables bound in the literal
     * @return                                      the goodness of the binding
     */
    protected int getBindingGoodness(Literal literal,boolean[] boundVariables) {
        int goodness=super.getBindingGoodness(literal,boundVariables);
        if (literal.isPositive()) {
            String predicateFullName=literal.getPredicate().getFullName();
            if ("OIModelEntity/6".equals(predicateFullName)) {
                // Invocation to OIModelEntity with ID or URI bound it typically excellent, since these are the unique fields.
                if (boundVariables[0] || boundVariables[1])
                    goodness+=1000;
            }
            else if ("RelationInstance_a/3".equals(predicateFullName)) {
                // A query to relations where the property is bound to kaon:references and source is inbound is not efficient, since
                // there are lots of instances being referenced.
                // Similarly for the kaon:inLanguage property.
                if (boundVariables[0] && !boundVariables[1]) {
                    String propertyURI=getURIFromConstant(literal.getTerm(0));
                    if (KAONVocabularyAdaptor.INSTANCE.getReferences().equals(propertyURI) || KAONVocabularyAdaptor.INSTANCE.getInLanguage().equals(propertyURI))
                        goodness-=1000;
                }
            }
            else if ("AttributeInstance_a/3".equals(predicateFullName)) {
                // A query to attributes where the property is bound to kaon:value and source is inbound is not efficient, since
                // there are lots of instances having a value.
                if (boundVariables[0] && !boundVariables[1] && !boundVariables[2]) {
                    String propertyURI=getURIFromConstant(literal.getTerm(0));
                    if (KAONVocabularyAdaptor.INSTANCE.getValue().equals(propertyURI))
                        goodness-=1000;
                }
            }
            else if ("ConceptInstance_a/2".equals(predicateFullName)) {
                // A query to all instances of some lexical entry isn't a good idea, since there are many lexical entries.
                if (boundVariables[0] && !boundVariables[1]) {
                    String propertyURI=getURIFromConstant(literal.getTerm(0));
                    if (propertyURI!=null && propertyURI.toString().startsWith(KAONVocabularyAdaptor.KAON))
                        goodness-=500;
                }
            }
        }
        return goodness;
    }
    /**
     * Returns the URI of the bound constant, or <code>null</code> if there is no URI.
     *
     * @param term                                  the term
     * @return                                      the URI of the constant in the term
     */
    protected String getURIFromConstant(Term term) {
        if (term instanceof Constant) {
            Object value=((Constant)term).getValue();
            if (value instanceof EntityURI)
                return ((EntityURI)value).getEntityURI();
        }
        return null;
    }
}
