package edu.unika.aifb.kaon.engineeringserver.query;

import java.util.Map;
import java.util.HashMap;
import java.sql.Connection;
import java.sql.Statement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;

import edu.unika.aifb.kaon.datalog.*;
import edu.unika.aifb.kaon.datalog.jdbc.*;

/**
 * The extensional database for the engineering server.
 */
public class EngineeringServerExtensionalDatabase extends JDBCExtensionalDatabase {
    /** The map associating information about predicates in the database with their names. */
    protected static final Map s_supportedPredicates=new HashMap();
    static {
        registerPredicateDBInfo(s_supportedPredicates,true,"OIModelEntity","OIModelEntity",new String[] { "entityURI","entityID","isAttribute","isSymmetric","isTransitive" },new int[] { ServerTypeManager.TYPE_ENTITY_URI,Types.INTEGER,Types.BOOLEAN,Types.BOOLEAN,Types.BOOLEAN });
        registerPredicateDBInfo(s_supportedPredicates,true,"InverseProperty_i","InverseProperty",new String[] { "propertyID","inversePropertyID" },new int[] { Types.INTEGER,Types.INTEGER });
        registerPredicateDBInfo(s_supportedPredicates,true,"ConceptHierarchy_i","ConceptHierarchy",new String[] { "superConceptID","subConceptID" },new int[] { Types.INTEGER,Types.INTEGER });
        registerPredicateDBInfo(s_supportedPredicates,true,"ConceptInstance_i","ConceptInstance",new String[] { "conceptID","instanceID" },new int[] { Types.INTEGER,Types.INTEGER });
        registerPredicateDBInfo(s_supportedPredicates,true,"PropertyHierarchy_i","PropertyHierarchy",new String[] { "superPropertyID","subPropertyID" },new int[] { Types.INTEGER,Types.INTEGER });
        registerPredicateDBInfo(s_supportedPredicates,true,"PropertyDomain_i","PropertyDomain",new String[] { "propertyID","conceptID","minimumCardinality","maximumCardinality" },new int[] { Types.INTEGER,Types.INTEGER,Types.INTEGER,Types.INTEGER });
        registerPredicateDBInfo(s_supportedPredicates,true,"PropertyRange_i","PropertyRange",new String[] { "propertyID","conceptID" },new int[] { Types.INTEGER,Types.INTEGER });
        registerPredicateDBInfo(s_supportedPredicates,true,"RelationInstance_i","RelationInstance",new String[] { "propertyID","sourceInstanceID","targetInstanceID" },new int[] { Types.INTEGER,Types.INTEGER,Types.INTEGER });
        registerPredicateDBInfo(s_supportedPredicates,true,"AttributeInstance_i","AttributeInstance",new String[] { "propertyID","sourceInstanceID","textValue" },new int[] { Types.INTEGER,Types.INTEGER,Types.VARCHAR });
        registerPredicateDBInfo(s_supportedPredicates,true,"RegExp","AttributeInstance",new String[] { "textValue","textValue" },new int[] { Types.VARCHAR,TypeManager.TYPE_REGULAR_EXPRESSION });
    }

    /** The ID of the model for which this database is installed. */
    protected int m_modelID;
    /** The IN condition restricting the model ID. */
    protected String m_modelIDRestriction;

    /**
     * Creates an instance of this class.
     *
     * @param modelID                           the ID of the model
     */
    public EngineeringServerExtensionalDatabase(int modelID) {
        super(s_supportedPredicates);
        m_modelID=modelID;
    }
    /**
     * Sets the connection.
     *
     * @param connection                        the connection (may be <code>null</code> if no connection is set)
     * @param databaseManager                   the database manager (may be <code>null</code> if no connection is set)
     * @throws DatalogException                 thrown if there is an error
     */
    public void setConnection(Connection connection,DatabaseManager databaseManager) throws DatalogException {
        m_modelIDRestriction=null;
        super.setConnection(connection,databaseManager);
        if (m_connection!=null) {
            try {
                StringBuffer buffer=new StringBuffer();
                buffer.append('(');
                boolean first=true;
                Statement statement=m_connection.createStatement();
                try {
                    ResultSet resultSet=statement.executeQuery("SELECT includedModelID FROM AllIncludedOIModels WHERE includingModelID="+m_modelID);
                    try {
                        while (resultSet.next()) {
                            int includedModelID=resultSet.getInt(1);
                            if (first)
                                first=false;
                            else
                                buffer.append(",");
                            buffer.append(includedModelID);
                        }
                    }
                    finally {
                        resultSet.close();
                    }
                }
                finally {
                    statement.close();
                }
                buffer.append(')');
                m_modelIDRestriction=buffer.toString();
            }
            catch (SQLException e) {
                throw new DatalogException("SQL error",e);
            }
        }
    }
    /**
     * Initializes this literal information with initial conditions. Subclasses can override this to provide additional conditions.
     *
     * @param literalInfo                       information about the literal
     */
    public void addInitialConditions(AbstractQueryGenerator.LiteralInfo literalInfo) {
        literalInfo.addConstantCondition("modelID"," IN ",m_modelIDRestriction);
    }
    public static DatabaseManager createDatabaseManager(Connection connection) throws DatalogException {
        DatabaseManager databaseManager=JDBCExtensionalDatabase.createDatabaseManager(connection);
        databaseManager.setTypeManager(ServerTypeManager.INSTANCE);
        return databaseManager;
    }
}
