package edu.unika.aifb.kaon.engineeringserver.loader;

import java.sql.Connection;
import java.sql.Statement;
import java.sql.ResultSet;
import java.sql.SQLException;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;

/**
 * Object loader for SQL2 compliant databases.
 */
public class ObjectLoaderSQL2 extends AbstractSQLObjectLoader {
    /** The IN condition restricting the model ID. */
    protected String m_modelIDRestriction;

    /**
     * Creates an instance of this class and attaches it to given connection.
     *
     * @param connection                    connection from which loading is performed
     * @param modelID                       the ID of the model for which loading is performed
     * @throws KAONException                thrown if there is an error
     */
    public ObjectLoaderSQL2(Connection connection,int modelID) throws KAONException {
        super(connection,modelID);
        try {
            StringBuffer buffer=new StringBuffer();
            boolean first=true;
            Statement statement=m_connection.createStatement();
            try {
                ResultSet resultSet=statement.executeQuery("SELECT includedModelID FROM AllIncludedOIModels WHERE includingModelID="+m_modelID);
                try {
                    while (resultSet.next()) {
                        int includedModelID=resultSet.getInt(1);
                        if (first)
                            first=false;
                        else
                            buffer.append(",");
                        buffer.append(includedModelID);
                    }
                }
                finally {
                    resultSet.close();
                }
            }
            finally {
                statement.close();
            }
            m_modelIDRestriction=buffer.toString();
        }
        catch (SQLException e) {
            throw new KAONException("SQL error",e);
        }
    }
    protected String getLoadBasicsQuery(String entityURIs,int loadFlag) {
        StringBuffer buffer=new StringBuffer();
        buffer.append("SELECT o.entityURI,o.modelID,o.conceptVersion,o.instanceVersion,o.propertyVersion,o.isAttribute,o.isSymmetric,o.isTransitive,i.entityURI,i.propertyVersion,ip.modelID "+
                      "FROM OIModelEntity o "+
                      "LEFT JOIN InverseProperty ip ON o.entityID=ip.propertyID AND ip.modelID IN (");
        buffer.append(m_modelIDRestriction);
        buffer.append(") LEFT JOIN OIModelEntity i ON ip.inversePropertyID=i.entityID "+
                      "WHERE o.modelID IN (");
        buffer.append(m_modelIDRestriction);
        buffer.append(") AND o.entityURI IN (");
        buffer.append(entityURIs);
        buffer.append(")");
        return buffer.toString();
    }
    protected String getLoadSuperConceptsQuery(String entityURIs,int loadFlag) {
        StringBuffer buffer=new StringBuffer();
        buffer.append("SELECT 1 AS rowType,ch.modelID AS modelID,c.entityURI AS objectURI,c.conceptVersion AS objectVersion,sc.entityURI AS superConceptURI,sc.conceptVersion AS superConceptVersion,0,0 "+
                      "FROM OIModelEntity c "+
                      "LEFT JOIN ConceptHierarchy ch ON c.entityID=ch.subConceptID AND ch.modelID IN (");
        buffer.append(m_modelIDRestriction);
        buffer.append(") LEFT JOIN OIModelEntity sc ON ch.superConceptID=sc.entityID "+
                      "WHERE c.entityURI IN (");
        buffer.append(entityURIs);
        buffer.append(") AND c.modelID IN (");
        buffer.append(m_modelIDRestriction);
        buffer.append(")");
        return buffer.toString();
    }
    protected String getLoadSubConceptsQuery(String entityURIs,int loadFlag) {
        StringBuffer buffer=new StringBuffer();
        buffer.append("SELECT 2 AS rowType,ch.modelID AS modelID,c.entityURI AS objectURI,c.conceptVersion AS objectVersion,sc.entityURI AS subConceptURI,sc.conceptVersion AS subConceptVersion,0,0 "+
                      "FROM OIModelEntity c "+
                      "LEFT JOIN ConceptHierarchy ch ON c.entityID=ch.superConceptID AND ch.modelID IN (");
        buffer.append(m_modelIDRestriction);
        buffer.append(") LEFT JOIN OIModelEntity sc ON ch.subConceptID=sc.entityID "+
                      "WHERE c.entityURI IN (");
        buffer.append(entityURIs);
        buffer.append(") AND c.modelID IN (");
        buffer.append(m_modelIDRestriction);
        buffer.append(")");
        return buffer.toString();
    }
    protected String getLoadPropertiesFromQuery(String entityURIs,int loadFlag) {
        StringBuffer buffer=new StringBuffer();
        buffer.append("SELECT 3 AS rowType,pd.modelID AS modelID,c.entityURI AS objectURI,c.propertyVersion AS objectVersion,p.entityURI AS propertyURI,p.propertyVersion AS propertyVersion,0,0 "+
                      "FROM OIModelEntity c "+
                      "LEFT JOIN PropertyDomain pd ON c.entityID=pd.conceptID AND pd.modelID IN (");
        buffer.append(m_modelIDRestriction);
        buffer.append(") LEFT JOIN OIModelEntity p ON pd.propertyID=p.entityID "+
                      "WHERE c.entityURI IN (");
        buffer.append(entityURIs);
        buffer.append(") AND c.modelID IN (");
        buffer.append(m_modelIDRestriction);
        buffer.append(")");
        return buffer.toString();
    }
    protected String getLoadPropertiesToQuery(String entityURIs,int loadFlag) {
        StringBuffer buffer=new StringBuffer();
        buffer.append("SELECT 4 AS rowType,pr.modelID AS modelID,c.entityURI AS objectURI,c.propertyVersion AS objectVersion,p.entityURI AS propertyURI,p.propertyVersion AS propertyVersion,0,0 "+
                      "FROM OIModelEntity c "+
                      "LEFT JOIN PropertyRange pr ON c.entityID=pr.conceptID AND pr.modelID IN (");
        buffer.append(m_modelIDRestriction);
        buffer.append(") LEFT JOIN OIModelEntity p ON pr.propertyID=p.entityID "+
                      "WHERE c.entityURI IN (");
        buffer.append(entityURIs);
        buffer.append(") AND c.modelID IN (");
        buffer.append(m_modelIDRestriction);
        buffer.append(")");
        return buffer.toString();
    }
    protected String getLoadConceptInstancesQuery(String entityURIs,int loadFlag) {
        StringBuffer buffer=new StringBuffer();
        buffer.append("SELECT 5 AS rowType,ci.modelID AS modelID,c.entityURI AS objectURI,c.conceptVersion AS objectVersion,i.entityURI AS instanceURI,i.instanceVersion AS instanceVersion,0,0 "+
                      "FROM OIModelEntity c "+
                      "LEFT JOIN ConceptInstance ci ON c.entityID=ci.conceptID AND ci.modelID IN (");
        buffer.append(m_modelIDRestriction);
        buffer.append(") LEFT JOIN OIModelEntity i ON ci.instanceID=i.entityID "+
                      "WHERE c.entityURI IN (");
        buffer.append(entityURIs);
        buffer.append(") AND c.modelID IN (");
        buffer.append(m_modelIDRestriction);
        buffer.append(")");
        return buffer.toString();
    }
    protected String getLoadSuperPropertiesQuery(String entityURIs,int loadFlag) {
        StringBuffer buffer=new StringBuffer();
        buffer.append("SELECT 6 AS rowType,ph.modelID AS modelID,p.entityURI AS objectURI,p.propertyVersion AS objectVersion,sp.entityURI AS superPropertyURI,sp.propertyVersion AS superPropertyVersion,0,0 "+
                      "FROM OIModelEntity p "+
                      "LEFT JOIN PropertyHierarchy ph ON p.entityID=ph.subPropertyID AND ph.modelID IN (");
        buffer.append(m_modelIDRestriction);
        buffer.append(") LEFT JOIN OIModelEntity sp ON ph.superPropertyID=sp.entityID "+
                      "WHERE p.entityURI IN (");
        buffer.append(entityURIs);
        buffer.append(") AND p.modelID IN (");
        buffer.append(m_modelIDRestriction);
        buffer.append(")");
        return buffer.toString();
    }
    protected String getLoadSubPropertiesQuery(String entityURIs,int loadFlag) {
        StringBuffer buffer=new StringBuffer();
        buffer.append("SELECT 7 AS rowType,ph.modelID AS modelID,p.entityURI AS objectURI,p.propertyVersion AS objectVersion,sp.entityURI AS subPropertyURI,sp.propertyVersion AS subPropertyVersion,0,0 "+
                      "FROM OIModelEntity p "+
                      "LEFT JOIN PropertyHierarchy ph ON p.entityID=ph.superPropertyID AND ph.modelID IN (");
        buffer.append(m_modelIDRestriction);
        buffer.append(") LEFT JOIN OIModelEntity sp ON ph.subPropertyID=sp.entityID "+
                      "WHERE p.entityURI IN (");
        buffer.append(entityURIs);
        buffer.append(") AND p.modelID IN (");
        buffer.append(m_modelIDRestriction);
        buffer.append(")");
        return buffer.toString();
    }
    protected String getLoadPropertyDomainsQuery(String entityURIs,int loadFlag) {
        StringBuffer buffer=new StringBuffer();
        buffer.append("SELECT 8 AS rowType,pd.modelID AS modelID,p.entityURI AS objectURI,p.propertyVersion AS objectVersion,c.entityURI AS conceptURI,c.conceptVersion AS conceptVersion,pd.minimumCardinality,pd.maximumCardinality "+
                      "FROM OIModelEntity p "+
                      "LEFT JOIN PropertyDomain pd ON p.entityID=pd.propertyID AND pd.modelID IN (");
        buffer.append(m_modelIDRestriction);
        buffer.append(") LEFT JOIN OIModelEntity c ON pd.conceptID=c.entityID "+
                      "WHERE p.entityURI IN (");
        buffer.append(entityURIs);
        buffer.append(") AND p.modelID IN (");
        buffer.append(m_modelIDRestriction);
        buffer.append(")");
        return buffer.toString();
    }
    protected String getLoadPropertyRangesQuery(String entityURIs,int loadFlag) {
        StringBuffer buffer=new StringBuffer();
        buffer.append("SELECT 9 AS rowType,pr.modelID AS modelID,p.entityURI AS objectURI,p.propertyVersion AS objectVersion,c.entityURI AS conceptURI,c.conceptVersion AS conceptVersion,0,0 "+
                      "FROM OIModelEntity p "+
                      "LEFT JOIN PropertyRange pr ON p.entityID=pr.propertyID AND pr.modelID IN (");
        buffer.append(m_modelIDRestriction);
        buffer.append(") LEFT JOIN OIModelEntity c ON pr.conceptID=c.entityID "+
                      "WHERE p.entityURI IN (");
        buffer.append(entityURIs);
        buffer.append(") AND p.modelID IN (");
        buffer.append(m_modelIDRestriction);
        buffer.append(")");
        return buffer.toString();
    }
    protected String getLoadParentConceptsQuery(String entityURIs,int loadFlag) {
        StringBuffer buffer=new StringBuffer();
        buffer.append("SELECT 10 AS rowType,ci.modelID AS modelID,i.entityURI AS objectURI,i.instanceVersion AS objectVersion,c.entityURI AS conceptURI,c.conceptVersion AS conceptVersion,0,0 "+
                      "FROM OIModelEntity i "+
                      "LEFT JOIN ConceptInstance ci ON i.entityID=ci.instanceID AND ci.modelID IN (");
        buffer.append(m_modelIDRestriction);
        buffer.append(") LEFT JOIN OIModelEntity c ON ci.conceptID=c.entityID "+
                      "WHERE i.entityURI IN (");
        buffer.append(entityURIs);
        buffer.append(") AND i.modelID IN (");
        buffer.append(m_modelIDRestriction);
        buffer.append(")");
        return buffer.toString();
    }
    protected String getLoadInstancePropertiesFromQuery(String entityURIs,int loadFlag) {
        StringBuffer buffer=new StringBuffer();
        buffer.append("SELECT 11 AS rowType,ri.modelID AS modelID,si.entityURI AS objectURI,si.instanceVersion AS objectVersion,p.entityURI AS propertyURI,p.propertyVersion AS propertyVersion,ti.entityURI AS targetInstanceURI,ti.instanceVersion AS targetInstanceVersion,'' "+
                	  "FROM OIModelEntity si "+
	                  "LEFT JOIN RelationInstance ri ON si.entityID=ri.sourceInstanceID AND ri.modelID IN (");
        buffer.append(m_modelIDRestriction);
        buffer.append(") LEFT JOIN OIModelEntity p ON ri.propertyID=p.entityID "+
                      "LEFT JOIN OIModelEntity ti ON ri.targetInstanceID=ti.entityID "+
                      "WHERE si.entityURI IN (");
        buffer.append(entityURIs);
        buffer.append(") AND si.modelID IN (");
        buffer.append(m_modelIDRestriction);
        buffer.append(") UNION ALL SELECT 11 AS rowType,ai.modelID AS modelID,si.entityURI AS objectURI,si.instanceVersion AS objectVersion,p.entityURI AS propertyURI,p.propertyVersion AS propertyVersion,'',0,ai.textValue AS textValue "+
                	  "FROM OIModelEntity si "+
	                  "LEFT JOIN AttributeInstance ai ON si.entityID=ai.sourceInstanceID AND ai.modelID IN (");
        buffer.append(m_modelIDRestriction);
        buffer.append(") LEFT JOIN OIModelEntity p ON ai.propertyID=p.entityID "+
                      "WHERE si.entityURI IN (");
        buffer.append(entityURIs);
        buffer.append(") AND si.modelID IN (");
        buffer.append(m_modelIDRestriction);
        buffer.append(")");
        return buffer.toString();
    }
    protected String getLoadInstancePropertiesToQuery(String entityURIs,int loadFlag) {
        StringBuffer buffer=new StringBuffer();
        buffer.append("SELECT 12 AS rowType,ri.modelID AS modelID,ti.entityURI AS objectURI,ti.instanceVersion AS objectVersion,p.entityURI AS propertyURI,p.propertyVersion AS propertyVersion,si.entityURI AS sourceInstanceURI,si.instanceVersion AS sourceInstanceVersion,'' "+
                	  "FROM OIModelEntity ti "+
	                  "LEFT JOIN RelationInstance ri ON ti.entityID=ri.targetInstanceID AND ri.modelID IN (");
        buffer.append(m_modelIDRestriction);
        buffer.append(") LEFT JOIN OIModelEntity p ON ri.propertyID=p.entityID "+
                      "LEFT JOIN OIModelEntity si ON ri.sourceInstanceID=si.entityID "+
                      "WHERE ti.entityURI IN (");
        buffer.append(entityURIs);
        buffer.append(") AND ti.modelID IN (");
        buffer.append(m_modelIDRestriction);
        buffer.append(")");
        return buffer.toString();
    }
    protected String getLoadPropertyInstancesQuery(String entityURIs,int loadFlag) {
        StringBuffer buffer=new StringBuffer();
        buffer.append("(SELECT ri.modelID AS modelID,p.entityURI AS propertyURI,p.propertyVersion AS propertyVersion,si.entityURI AS sourceInstanceURI,si.instanceVersion AS sourceInstanceVersion,ti.entityURI AS targetInstanceURI,ti.instanceVersion AS targetInstanceVersion,'' "+
                	  "FROM OIModelEntity p "+
	                  "LEFT JOIN RelationInstance ri ON p.entityID=ri.propertyID AND ri.modelID IN (");
        buffer.append(m_modelIDRestriction);
        buffer.append(") LEFT JOIN OIModelEntity si ON ri.sourceInstanceID=si.entityID "+
                      "LEFT JOIN OIModelEntity ti ON ri.targetInstanceID=ti.entityID "+
                      "WHERE p.entityURI IN (");
        buffer.append(entityURIs);
        buffer.append(") AND p.modelID IN (");
        buffer.append(m_modelIDRestriction);
        buffer.append(") UNION ALL SELECT ai.modelID AS modelID,p.entityURI AS propertyURI,p.propertyVersion AS propertyVersion,si.entityURI AS sourceInstanceURI,si.instanceVersion AS sourceInstanceVersion,'',0,textValue AS textValue "+
                	  "FROM OIModelEntity p "+
	                  "LEFT JOIN AttributeInstance ai ON p.entityID=ai.propertyID AND ai.modelID IN (");
        buffer.append(m_modelIDRestriction);
        buffer.append(") LEFT JOIN OIModelEntity si ON ai.sourceInstanceID=si.entityID "+
                      "WHERE p.entityURI IN (");
        buffer.append(entityURIs);
        buffer.append(") AND p.modelID IN (");
        buffer.append(m_modelIDRestriction);
        buffer.append(")) ORDER BY propertyURI");
        return buffer.toString();
    }
    protected String getLoadRelatedEntitiesQuery(String entityURIs,int loadFlag) {
        StringBuffer buffer=new StringBuffer();
        boolean first=true;
        buffer.append("(");
        if ((loadFlag & OIModel.LOAD_SUPER_CONCEPTS)!=0)
            first=appendQueryPart(first,getLoadSuperConceptsQuery(entityURIs,loadFlag),buffer);
        if ((loadFlag & OIModel.LOAD_SUB_CONCEPTS)!=0)
            first=appendQueryPart(first,getLoadSubConceptsQuery(entityURIs,loadFlag),buffer);
        if ((loadFlag & OIModel.LOAD_PROPERTIES_FROM)!=0)
            first=appendQueryPart(first,getLoadPropertiesFromQuery(entityURIs,loadFlag),buffer);
        if ((loadFlag & OIModel.LOAD_PROPERTIES_TO)!=0)
            first=appendQueryPart(first,getLoadPropertiesToQuery(entityURIs,loadFlag),buffer);
        if ((loadFlag & OIModel.LOAD_CONCEPT_INSTANCES)!=0)
            first=appendQueryPart(first,getLoadConceptInstancesQuery(entityURIs,loadFlag),buffer);
        if ((loadFlag & OIModel.LOAD_SUPER_PROPERTIES)!=0)
            first=appendQueryPart(first,getLoadSuperPropertiesQuery(entityURIs,loadFlag),buffer);
        if ((loadFlag & OIModel.LOAD_SUB_PROPERTIES)!=0)
            first=appendQueryPart(first,getLoadSubPropertiesQuery(entityURIs,loadFlag),buffer);
        if ((loadFlag & OIModel.LOAD_PROPERTY_DOMAINS)!=0)
            first=appendQueryPart(first,getLoadPropertyDomainsQuery(entityURIs,loadFlag),buffer);
        if ((loadFlag & OIModel.LOAD_PROPERTY_RANGES)!=0)
            first=appendQueryPart(first,getLoadPropertyRangesQuery(entityURIs,loadFlag),buffer);
        if ((loadFlag & OIModel.LOAD_INSTANCE_PARENT_CONCEPTS)!=0)
            first=appendQueryPart(first,getLoadParentConceptsQuery(entityURIs,loadFlag),buffer);
        buffer.append(") ORDER BY rowType,objectURI");
        return buffer.toString();
    }
    protected String getLoadInstancePropertyValuesQuery(String entityURIs,int loadFlag) {
        StringBuffer buffer=new StringBuffer();
        boolean first=true;
        buffer.append("(");
        if ((loadFlag & OIModel.LOAD_INSTANCE_FROM_PROPERTY_VALUES)!=0)
            first=appendQueryPart(first,getLoadInstancePropertiesFromQuery(entityURIs,loadFlag),buffer);
        if ((loadFlag & OIModel.LOAD_INSTANCE_TO_PROPERTY_VALUES)!=0)
            first=appendQueryPart(first,getLoadInstancePropertiesToQuery(entityURIs,loadFlag),buffer);
        buffer.append(") ORDER BY rowType,objectURI");
        return buffer.toString();
    }
    protected boolean appendQueryPart(boolean first,String query,StringBuffer buffer) {
        if (!first)
            buffer.append(" UNION ALL ");
        buffer.append(" ( ");
        buffer.append(query);
        buffer.append(" ) ");
        return false;
    }
    protected String getLoadConceptsQuery() {
        StringBuffer buffer=new StringBuffer();
        buffer.append("SELECT entityURI,conceptVersion FROM OIModelEntity WHERE conceptVersion<>"+Integer.MAX_VALUE+" AND modelID IN (");
        buffer.append(m_modelIDRestriction);
        buffer.append(")");
        return buffer.toString();
    }
    protected String getLoadPropertiesQuery() {
        StringBuffer buffer=new StringBuffer();
        buffer.append("SELECT entityURI,propertyVersion FROM OIModelEntity WHERE propertyVersion<>"+Integer.MAX_VALUE+" AND modelID IN (");
        buffer.append(m_modelIDRestriction);
        buffer.append(")");
        return buffer.toString();
    }
    protected String getLoadInstancesQuery() {
        StringBuffer buffer=new StringBuffer();
        buffer.append("SELECT entityURI,instanceVersion FROM OIModelEntity WHERE instanceVersion<>"+Integer.MAX_VALUE+" AND modelID IN (");
        buffer.append(m_modelIDRestriction);
        buffer.append(")");
        return buffer.toString();
    }
}
