package edu.unika.aifb.kaon.engineeringserver.loader;

import java.sql.Connection;
import java.sql.DatabaseMetaData;

import edu.unika.aifb.kaon.api.*;

/**
 * Object loader for PostgreSQL. The only PostgreSQL specific thing is turning off sequential scans for related entities query.
 */
public class ObjectLoaderPostgreSQL extends ObjectLoaderSQL2 {
    /**
     * Creates an instance of this class and attaches it to given connection.
     *
     * @param connection                    connection from which loading is performed
     * @param modelID                       the ID of the model for which loading is performed
     * @throws KAONException                thrown if there is an error
     */
    public ObjectLoaderPostgreSQL(Connection connection,int modelID) throws KAONException {
        super(connection,modelID);
    }
    /**
     * Overridden to turn off the sequential scan.
     *
     * @param entityURIs                    the URIs for the entities being loaded
     * @param loadFlag                      the flag for loading
     * @return                              the query
     */
    protected String getLoadRelatedEntitiesQuery(String entityURIs,int loadFlag) {
        return "set enable_seqscan=off; "+super.getLoadRelatedEntitiesQuery(entityURIs,loadFlag)+"; set enable_seqscan=on;";
    }
    /**
     * Returns <code>true</code> if the connection is to an PostgreSQL database.
     *
     * @param connection                        the connection
     * @return                                  <code>true</code> if this is PostgreSQL
     */
    public static boolean isPostgreSQL(Connection connection) {
        try {
            DatabaseMetaData databaseMetaData=connection.getMetaData();
            return "PostgreSQL".equalsIgnoreCase(databaseMetaData.getDatabaseProductName());
        }
        catch (Throwable ignored) {
            // PostrgreSQL shouldn't throw an error here
            return false;
        }
    }
}
