package edu.unika.aifb.kaon.engineeringserver.interfaces;

import javax.naming.NamingException;
import javax.naming.InitialContext;

import javax.rmi.PortableRemoteObject;

import java.util.Hashtable;

/**
 * Utility class for EngineeringServer.
 * @xdoclet-generated at 13.08.2004 11:27:56
 */
public class EngineeringServerUtil
{
   // Home interface lookup methods

   /**
    * Obtain remote home interface from default initial context
    * @return Home interface for EngineeringServer. Lookup using JNDI_NAME
    */
   public static edu.unika.aifb.kaon.engineeringserver.interfaces.EngineeringServerHome getHome() throws NamingException
   {
      InitialContext initialContext = new InitialContext();
      try {
         java.lang.Object objRef = initialContext.lookup(edu.unika.aifb.kaon.engineeringserver.interfaces.EngineeringServerHome.JNDI_NAME);
         edu.unika.aifb.kaon.engineeringserver.interfaces.EngineeringServerHome home = (edu.unika.aifb.kaon.engineeringserver.interfaces.EngineeringServerHome)PortableRemoteObject.narrow(objRef, edu.unika.aifb.kaon.engineeringserver.interfaces.EngineeringServerHome.class);
         return home;
      } finally {
         initialContext.close();
      }
   }

   /**
    * Obtain remote home interface from parameterised initial context
    * @param environment Parameters to use for creating initial context
    * @return Home interface for EngineeringServer. Lookup using JNDI_NAME
    */
   public static edu.unika.aifb.kaon.engineeringserver.interfaces.EngineeringServerHome getHome( Hashtable environment ) throws NamingException
   {
      InitialContext initialContext = new InitialContext(environment);
      try {
         java.lang.Object objRef = initialContext.lookup(edu.unika.aifb.kaon.engineeringserver.interfaces.EngineeringServerHome.JNDI_NAME);
         edu.unika.aifb.kaon.engineeringserver.interfaces.EngineeringServerHome home = (edu.unika.aifb.kaon.engineeringserver.interfaces.EngineeringServerHome)PortableRemoteObject.narrow(objRef, edu.unika.aifb.kaon.engineeringserver.interfaces.EngineeringServerHome.class);
         return home;
      } finally {
         initialContext.close();
      }
   }

   /**
    * Obtain local home interface from default initial context
    * @return Local home interface for EngineeringServer. Lookup using JNDI_NAME
    */
   public static edu.unika.aifb.kaon.engineeringserver.interfaces.EngineeringServerLocalHome getLocalHome() throws NamingException
   {
      InitialContext initialContext = new InitialContext();
      try {
         // Local homes shouldn't be narrowed, as there is no RMI involved.
         edu.unika.aifb.kaon.engineeringserver.interfaces.EngineeringServerLocalHome localHome = (edu.unika.aifb.kaon.engineeringserver.interfaces.EngineeringServerLocalHome) initialContext.lookup(edu.unika.aifb.kaon.engineeringserver.interfaces.EngineeringServerLocalHome.JNDI_NAME);
         return localHome;
      } finally {
         initialContext.close();
      }
   }

}
