package edu.unika.aifb.kaon.engineeringserver.ejb;

import java.util.List;
import java.util.LinkedList;
import java.util.Map;
import java.util.HashMap;
import java.util.Set;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Collections;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.sql.Connection;
import javax.sql.DataSource;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.ejb.EJBException;
import javax.naming.NamingException;
import javax.naming.Context;
import javax.naming.InitialContext;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.apiproxy.*;
import edu.unika.aifb.kaon.apiproxy.source.*;

import edu.unika.aifb.kaon.engineeringserver.loader.*;
import edu.unika.aifb.kaon.engineeringserver.change.*;
import edu.unika.aifb.kaon.engineeringserver.dao.*;
import edu.unika.aifb.kaon.engineeringserver.query.*;

import edu.unika.aifb.kaon.datalog.*;
import edu.unika.aifb.kaon.datalog.program.*;
import edu.unika.aifb.kaon.datalog.magic.*;
import edu.unika.aifb.kaon.datalog.evaluation.*;
import edu.unika.aifb.kaon.datalog.util.*;
import edu.unika.aifb.kaon.datalog.jdbc.*;

import edu.unika.aifb.kaon.query.ast.*;
import edu.unika.aifb.kaon.query.parser.*;
import edu.unika.aifb.kaon.query.compiler.*;

/**
 * @ejb.bean name="EngineeringServer" type="Stateless" view-type="both" jndi-name="ejb/engineeringserver/EngineeringServer"
 * @ejb.transaction type="Required"
 *
 * @ejb.resource-ref res-name="java:/KAON" res-type="javax.sql.DataSource" res-auth="Container"
 */
public class EngineeringServerBean implements SessionBean {
    /** The key for the engineering server extensional database. */
    protected static final String ENGINEERING_SERVER_EXTENSIONAL_DATABASE_KEY="ENGINEERING_SERVER_EXTENSIONAL_DATABASE_KEY";
    /** The key for the in-memory extensional database for temporary predicates. */
    protected static final String TEMPORARY_PREDICATES_EXTENSIONAL_DATABASE_KEY="TEMPORARY_PREDICATES_EXTENSIONAL_DATABASE_KEY";

    /** The map of datalog managers indexed by the model ID. */
    protected Map m_datalogManagers;
    /** The session context. */
    protected SessionContext m_sessionContext;
    /** The broadcaster for dispatching notifications to listeners. */
    protected ChangeBroadcaster m_changeBroadcaster;
    /** The type of the object loader. */
    protected int m_objectLoaderType;
    /** The type of the DAO. */
    protected int m_daoType;
    /** the database manager. */
    protected DatabaseManager m_databaseManager;

    public void setSessionContext(SessionContext sessionContext) {
        m_sessionContext=sessionContext;
        m_datalogManagers=new HashMap();
        try {
            Connection connection=getConnection();
            EngineeringServerDAO dao=null;
            try {
                m_objectLoaderType=AbstractSQLObjectLoader.getObjectLoaderType(connection);
                m_daoType=EngineeringServerDAO.getDAOType(connection);
                m_databaseManager=EngineeringServerExtensionalDatabase.createDatabaseManager(connection);
                dao=EngineeringServerDAO.createDAO(connection,m_daoType);
                dao.createDefaultModels();
            }
            catch (SQLException e) {
                throw new EJBException("Cannot create default models",e);
            }
            catch (DatalogException e) {
                throw new EJBException("Cannot create default models",e);
            }
            finally {
                if (dao!=null)
                    dao.close();
                releaseConnection(connection);
            }
        }
        catch (KAONException e) {
            throw new EJBException("Cannot create default models",e);
        }
    }
    public void unsetSessionContext() {
        m_sessionContext=null;
        m_datalogManagers=null;
    }
    public void ejbActivate() {
    }
    public void ejbPassivate() {
    }
    public void ejbRemove() {
        try {
            m_changeBroadcaster.close();
        }
        catch (KAONException e) {
            throw new EJBException("Cannot close broadcaster.",e);
        }
    }

    /**
     * @ejb.create-method
     * @ejb.permission role-name="KAONReader,KAONWriter"
     */
    public void ejbCreate() {
        try {
            m_changeBroadcaster=new ChangeBroadcaster();
        }
        catch (KAONException e) {
            throw new EJBException("Cannot initialize broadcaster.",e);
        }
    }

    /**
     * @ejb.interface-method
     * @ejb.permission role-name="KAONReader,KAONWriter"
     */
    public int getOIModelIDForLogicalURI(String logicalURI) throws KAONException {
        try {
            Connection connection=getConnection();
            EngineeringServerDAO dao=null;
            try {
                dao=EngineeringServerDAO.createDAO(connection,m_daoType);
                return dao.getOIModelDAO().getOIModelID(logicalURI);
            }
            finally {
                if (dao!=null)
                    dao.close();
                releaseConnection(connection);
            }
        }
        catch (KAONException e) {
            m_sessionContext.setRollbackOnly();
            throw e;
        }
        catch (SQLException e) {
            m_sessionContext.setRollbackOnly();
            throw new KAONException("SQL error",e);
        }
    }
    /**
     * @ejb.interface-method
     * @ejb.permission role-name="KAONReader,KAONWriter"
     */
    public String getOIModelLogicalURI(int modelID) throws KAONException {
        try {
            Connection connection=getConnection();
            EngineeringServerDAO dao=null;
            try {
                dao=EngineeringServerDAO.createDAO(connection,m_daoType);
                return dao.getOIModelDAO().getOIModelLogicalURI(modelID);
            }
            finally {
                if (dao!=null)
                    dao.close();
                releaseConnection(connection);
            }
        }
        catch (KAONException e) {
            m_sessionContext.setRollbackOnly();
            throw e;
        }
        catch (SQLException e) {
            m_sessionContext.setRollbackOnly();
            throw new KAONException("SQL error",e);
        }
    }
    /**
     * @ejb.interface-method
     * @ejb.permission role-name="KAONWriter"
     */
    public void deleteOIModel(String initiatingConnectionIdentifier,int modelID) throws KAONException {
        try {
            Connection connection=getConnection();
            EngineeringServerDAO dao=null;
            try {
                dao=EngineeringServerDAO.createDAO(connection,m_daoType);
                dao.getOIModelDAO().deleteOIModel(modelID);
                m_changeBroadcaster.modelNotify(initiatingConnectionIdentifier,modelID,"deleted");
            }
            finally {
                if (dao!=null)
                    dao.close();
                releaseConnection(connection);
            }
        }
        catch (KAONException e) {
            m_sessionContext.setRollbackOnly();
            throw e;
        }
        catch (SQLException e) {
            m_sessionContext.setRollbackOnly();
            throw new KAONException("SQL error",e);
        }
    }
    /**
     * @ejb.interface-method
     * @ejb.permission role-name="KAONReader,KAONWriter"
     */
    public int[] getDirectlyIncludedOIModelIDs(int modelID) throws KAONException {
        try {
            Connection connection=getConnection();
            EngineeringServerDAO dao=null;
            try {
                dao=EngineeringServerDAO.createDAO(connection,m_daoType);
                return dao.getOIModelDAO().getIncludedModelIDs(modelID);
            }
            finally {
                if (dao!=null)
                    dao.close();
                releaseConnection(connection);
            }
        }
        catch (KAONException e) {
            m_sessionContext.setRollbackOnly();
            throw e;
        }
        catch (SQLException e) {
            m_sessionContext.setRollbackOnly();
            throw new KAONException("SQL error",e);
        }
    }
    /**
     * @ejb.interface-method
     * @ejb.permission role-name="KAONReader,KAONWriter"
     */
    public int[] getAllOIModelIDs() throws KAONException {
        try {
            Connection connection=getConnection();
            EngineeringServerDAO dao=null;
            try {
                dao=EngineeringServerDAO.createDAO(connection,m_daoType);
                return dao.getOIModelDAO().getAllOIModelIDs();
            }
            finally {
                if (dao!=null)
                    dao.close();
                releaseConnection(connection);
            }
        }
        catch (KAONException e) {
            m_sessionContext.setRollbackOnly();
            throw e;
        }
        catch (SQLException e) {
            m_sessionContext.setRollbackOnly();
            throw new KAONException("SQL error",e);
        }
    }
    /**
     * @ejb.interface-method
     * @ejb.permission role-name="KAONReader,KAONWriter"
     */
    public Object[][] getAllOIModelInformation() throws KAONException {
        try {
            Connection connection=getConnection();
            EngineeringServerDAO dao=null;
            try {
                dao=EngineeringServerDAO.createDAO(connection,m_daoType);
                return dao.getOIModelDAO().getAllOIModelInformation();
            }
            finally {
                if (dao!=null)
                    dao.close();
                releaseConnection(connection);
            }
        }
        catch (KAONException e) {
            m_sessionContext.setRollbackOnly();
            throw e;
        }
        catch (SQLException e) {
            m_sessionContext.setRollbackOnly();
            throw new KAONException("SQL error",e);
        }
    }
    /**
     * @ejb.interface-method
     * @ejb.permission role-name="KAONWriter"
     */
    public int createOIModel(String logicalURI) throws KAONException {
        try {
            Connection connection=getConnection();
            EngineeringServerDAO dao=null;
            try {
                dao=EngineeringServerDAO.createDAO(connection,m_daoType);
                return dao.getOIModelDAO().createOIModel(logicalURI);
            }
            finally {
                if (dao!=null)
                    dao.close();
                releaseConnection(connection);
            }
        }
        catch (KAONException e) {
            m_sessionContext.setRollbackOnly();
            throw e;
        }
        catch (SQLException e) {
            m_sessionContext.setRollbackOnly();
            throw new KAONException("SQL error",e);
        }
    }
    /**
     * @ejb.interface-method
     * @ejb.permission role-name="KAONWriter"
     */
    public int createDuplicate(String sourceLogicalURI,String targetLogicalURI) throws KAONException {
        try {
            Connection connection=getConnection();
            EngineeringServerDAO dao=null;
            try {
                dao=EngineeringServerDAO.createDAO(connection,m_daoType);
                return dao.getOIModelDAO().createDuplicate(sourceLogicalURI,targetLogicalURI);
            }
            finally {
                if (dao!=null)
                    dao.close();
                releaseConnection(connection);
            }
        }
        catch (KAONException e) {
            m_sessionContext.setRollbackOnly();
            throw e;
        }
        catch (SQLException e) {
            m_sessionContext.setRollbackOnly();
            throw new KAONException("SQL error",e);
        }
    }
    /**
     * @ejb.interface-method
     * @ejb.permission role-name="KAONReader,KAONWriter"
     */
    public EntityInfo[] loadEntities(int modelID,String[] entityURIs,int loadFlag) throws KAONException {
        Connection connection=getConnection();
        try {
            AbstractObjectLoader loader=AbstractSQLObjectLoader.createSQLObjectLoader(connection,modelID,m_objectLoaderType);
            return loader.loadEntities(entityURIs,loadFlag);
        }
        finally {
            releaseConnection(connection);
        }
    }
    /**
     * @ejb.interface-method
     * @ejb.permission role-name="KAONReader,KAONWriter"
     */
    public boolean pointsToValue(int modelID,String instanceURI,String propertyURI,String targetInstanceURI,Object targetValue) throws KAONException {
        DatalogManager datalogManager=getDatalogManager(modelID);
        EngineeringServerExtensionalDatabase extensionalDatabase=(EngineeringServerExtensionalDatabase)datalogManager.getExtensionalDatabase(ENGINEERING_SERVER_EXTENSIONAL_DATABASE_KEY);
        Connection connection=null;
        try {
            connection=getConnection();
            extensionalDatabase.setConnection(connection,m_databaseManager);
            String unadornedQueryPredicateName;
            Constant[] boundValues;
            if (targetInstanceURI!=null) {
                unadornedQueryPredicateName="RelationInstance_a";
                boundValues=new Constant[] { new Constant(new EntityURI(propertyURI)),new Constant(new EntityURI(instanceURI)),new Constant(new EntityURI(targetInstanceURI)) };
            }
            else {
                unadornedQueryPredicateName="AttributeInstance_a";
                boundValues=new Constant[] { new Constant(new EntityURI(propertyURI)),new Constant(new EntityURI(instanceURI)),new Constant(targetValue) };
            }
            QueryOperator operator=getCachedQueryOperator(modelID,unadornedQueryPredicateName,boundValues);
            operator.start();
            boolean result=!operator.afterLast();
            operator.stop();
            return result;
        }
        catch (DatalogException error) {
            throw new KAONException("Error processing datalog query",error);
        }
        finally {
            MemoryExtensionalDatabase temporaryExtensionalDatabase=(MemoryExtensionalDatabase)datalogManager.getExtensionalDatabase(TEMPORARY_PREDICATES_EXTENSIONAL_DATABASE_KEY);
            temporaryExtensionalDatabase.clear();
            try {
                extensionalDatabase.setConnection(null,null);
            }
            catch (DatalogException ignored) {
            }
            if (connection!=null)
                releaseConnection(connection);
        }
    }
    /**
     * @ejb.interface-method
     * @ejb.permission role-name="KAONReader,KAONWriter"
     */
    public Object[][] getAllFromPropertyValues(int modelID,String instanceURI,String propertyURI) throws KAONException {
        return getAllFromToPropertyValues(modelID,"PropertyInstance_a",new Constant[] { propertyURI==null ? null : new Constant(new EntityURI(propertyURI)),new Constant(new EntityURI(instanceURI)),null,null },true);
    }
    /**
     * @ejb.interface-method
     * @ejb.permission role-name="KAONReader,KAONWriter"
     */
    public Object[][] getAllToPropertyValues(int modelID,String instanceURI,String propertyURI) throws KAONException {
        return getAllFromToPropertyValues(modelID,"RelationInstance_a",new Constant[] { propertyURI==null ? null : new Constant(new EntityURI(propertyURI)),null,new Constant(new EntityURI(instanceURI)) },false);
    }
    public Object[][] getAllFromToPropertyValues(int modelID,String unadornedQueryPredicateName,Constant[] boundValues,boolean fromValuesRequested) throws KAONException {
        DatalogManager datalogManager=getDatalogManager(modelID);
        EngineeringServerExtensionalDatabase extensionalDatabase=(EngineeringServerExtensionalDatabase)datalogManager.getExtensionalDatabase(ENGINEERING_SERVER_EXTENSIONAL_DATABASE_KEY);
        Connection connection=null;
        try {
            connection=getConnection();
            extensionalDatabase.setConnection(connection,m_databaseManager);
            QueryOperator operator=getCachedQueryOperator(modelID,unadornedQueryPredicateName,boundValues);
            Map result=new HashMap();
            operator.start();
            while (!operator.afterLast()) {
                Object[] tuple=operator.tuple();
                String loadedPropertyURI=((EntityURI)tuple[0]).getEntityURI();
                Set set=(Set)result.get(loadedPropertyURI);
                if (set==null) {
                    set=new HashSet();
                    result.put(loadedPropertyURI,set);
                }
                if (fromValuesRequested) {
                    if (tuple[2] instanceof EntityURI)
                        set.add(new EntityID(((EntityURI)tuple[2]).getEntityURI(),-2));
                    else if (tuple[3]!=null)
                        set.add(tuple[3]);
                }
                else {
                    if (tuple[1] instanceof EntityURI)
                        set.add(new EntityID(((EntityURI)tuple[1]).getEntityURI(),-2));
                }
                operator.next();
            }
            Object[][] resultArray=new Object[result.size()][];
            int rowIndex=0;
            Iterator iterator=result.keySet().iterator();
            while (iterator.hasNext()) {
                String loadedPropertyURI=(String)iterator.next();
                Set values=(Set)result.get(loadedPropertyURI);
                Object[] row=new Object[values.size()+1];
                row[0]=new EntityID(loadedPropertyURI,-2);
                Iterator valuesIterator=values.iterator();
                int columnIndex=1;
                while (valuesIterator.hasNext())
                    row[columnIndex++]=valuesIterator.next();
                resultArray[rowIndex++]=row;
            }
            return resultArray;
        }
        catch (DatalogException error) {
            throw new KAONException("Error processing datalog query",error);
        }
        finally {
            MemoryExtensionalDatabase temporaryExtensionalDatabase=(MemoryExtensionalDatabase)datalogManager.getExtensionalDatabase(TEMPORARY_PREDICATES_EXTENSIONAL_DATABASE_KEY);
            temporaryExtensionalDatabase.clear();
            try {
                extensionalDatabase.setConnection(null,null);
            }
            catch (DatalogException ignored) {
            }
            if (connection!=null)
                releaseConnection(connection);
        }
    }
    protected QueryOperator getCachedQueryOperator(int modelID,String unadornedQueryPredicateName,Constant[] boundValues) throws DatalogException {
        DatalogManager datalogManager=getDatalogManager(modelID);
        String queryPredicateName=unadornedQueryPredicateName+"_";
        for (int i=0;i<boundValues.length;i++)
            queryPredicateName+=boundValues[i]==null ? 'f' : 'b';
        Evaluator evaluator=datalogManager.getEvaluator(queryPredicateName);
        if (evaluator==null) {
            Predicate queryPredicate=StandardAxiomatization.PREDICATE_FACTORY.getPredicate(unadornedQueryPredicateName,boundValues.length);
            boolean[] boundVariables=new boolean[boundValues.length];
            for (int i=0;i<boundVariables.length;i++)
                boundVariables[i]=boundValues[i]==null ? false : true;
            MagicSetRewriting rewriting=new MagicSetRewriting(StandardAxiomatization.PROGRAM,queryPredicate,boundVariables,EngineeringServerSIPS.INSTANCE,PredicateBindingPatterns.ALL_BINDING_PATTERNS_ALLOWED);
            datalogManager.createMissingPredicates(rewriting.getMagicProgram(),TEMPORARY_PREDICATES_EXTENSIONAL_DATABASE_KEY);
            ProgramCompiler programCompiler=new ProgramCompiler(datalogManager,rewriting.getMagicProgram(),Collections.EMPTY_MAP,queryPredicate);
            evaluator=programCompiler.getEvaluator();
            datalogManager.registerEvaluator(queryPredicateName,evaluator,rewriting);
        }
        MagicSetRewriting rewriting=datalogManager.getMagicSetRewriting(queryPredicateName);
        QueryOperator operator=rewriting.getResultForBoundValues(datalogManager,boundValues);
        evaluator.execute();
        return operator;
    }
    /**
     * @ejb.interface-method
     * @ejb.permission role-name="KAONReader,KAONWriter"
     */
    public Object[] executeQuery(int modelID,String queryString) throws KAONException {
        DatalogManager datalogManager=getDatalogManager(modelID);
        EngineeringServerExtensionalDatabase extensionalDatabase=(EngineeringServerExtensionalDatabase)datalogManager.getExtensionalDatabase(ENGINEERING_SERVER_EXTENSIONAL_DATABASE_KEY);
        MemoryExtensionalDatabase temporaryExtensionalDatabase=(MemoryExtensionalDatabase)datalogManager.getExtensionalDatabase(TEMPORARY_PREDICATES_EXTENSIONAL_DATABASE_KEY);
        Program program=null;
        Predicate queryPredicate=null;
        Connection connection=null;
        try {
            connection=getConnection();
            ExpressionParser parser=new ExpressionParser(new StringReader(queryString));
            parser.setResolutionURI(new URI(getOIModelLogicalURI(modelID)));
            Expression queryExpression=parser.ExpressionEOF();
            PredicateFactory predicateFactory=new PredicateFactory();
            ExpressionToDatalogCompiler compiler=new ServerExpressionToDatalogCompiler(predicateFactory,modelID,connection);
            StandardAxiomatization.getAxiomatization(predicateFactory,compiler.getRules());
            queryPredicate=compiler.compileExpression(queryExpression,null);
            program=compiler.getProgram();
            extensionalDatabase.setConnection(connection,m_databaseManager);
            boolean[] boundVariables=new boolean[queryPredicate.getArity()];
            MagicSetRewriting rewriting=new MagicSetRewriting(program,queryPredicate,boundVariables,EngineeringServerSIPS.INSTANCE,PredicateBindingPatterns.ALL_BINDING_PATTERNS_ALLOWED);
            datalogManager.createMissingPredicates(rewriting.getMagicProgram(),TEMPORARY_PREDICATES_EXTENSIONAL_DATABASE_KEY);
            ProgramCompiler programCompiler=new ProgramCompiler(datalogManager,rewriting.getMagicProgram(),Collections.EMPTY_MAP,queryPredicate);
            Evaluator evaluator=programCompiler.getEvaluator();
            Constant[] boundValues=new Constant[queryPredicate.getArity()];
            QueryOperator operator=rewriting.getResultForBoundValues(datalogManager,boundValues);
            evaluator.execute();
            operator.start();
            List result=new LinkedList();
            while (!operator.afterLast()) {
                Object[] tuple=operator.tuple();
                if (tuple.length==1) {
                    Object object=tuple[0];
                    if (object instanceof EntityURI) {
                        EntityURI entityURI=(EntityURI)object;
                        result.add(new EntityID(entityURI.getEntityURI(),-2));
                    }
                    else
                        result.add(object);
                }
                else if (tuple.length==2) {
                    if (tuple[0] instanceof EntityURI) {
                        EntityURI entityURI=(EntityURI)tuple[0];
                        tuple[0]=new EntityID(entityURI.getEntityURI(),-2);
                    }
                    if (tuple[1] instanceof EntityURI) {
                        EntityURI entityURI=(EntityURI)tuple[1];
                        tuple[1]=new EntityID(entityURI.getEntityURI(),-2);
                    }
                    result.add(tuple);
                }
                operator.next();
            }
            Object[] resultArray=new Object[result.size()];
            result.toArray(resultArray);
            return resultArray;
        }
        catch (CompilationException error) {
            throw new KAONException("Error compiling an expression into datalog.",error);
        }
        catch (URISyntaxException error) {
            throw new KAONException("Invalid URI '"+error.getInput()+"'",error);
        }
        catch (ParseException error) {
            throw new KAONException("Error parsing query",error);
        }
        catch (TokenMgrError error) {
            throw new KAONException("Error tokenizing the query",error);
        }
        catch (DatalogException error) {
            throw new KAONException("Error processing datalog query",error);
        }
        finally {
            temporaryExtensionalDatabase.clear();
            try {
                extensionalDatabase.setConnection(null,null);
            }
            catch (DatalogException ignored) {
            }
            if (connection!=null)
                releaseConnection(connection);
        }
    }
    /**
     * @ejb.interface-method
     * @ejb.permission role-name="KAONReader,KAONWriter"
     */
    public EntityID[] getConcepts(int modelID) throws KAONException {
        Connection connection=getConnection();
        try {
            AbstractObjectLoader loader=AbstractSQLObjectLoader.createSQLObjectLoader(connection,modelID,m_objectLoaderType);
            return loader.loadConcepts();
        }
        finally {
            releaseConnection(connection);
        }
    }
    /**
     * @ejb.interface-method
     * @ejb.permission role-name="KAONReader,KAONWriter"
     */
    public EntityID[] getProperties(int modelID) throws KAONException {
        Connection connection=getConnection();
        try {
            AbstractObjectLoader loader=AbstractSQLObjectLoader.createSQLObjectLoader(connection,modelID,m_objectLoaderType);
            return loader.loadProperties();
        }
        finally {
            releaseConnection(connection);
        }
    }
    /**
     * @ejb.interface-method
     * @ejb.permission role-name="KAONReader,KAONWriter"
     */
    public EntityID[] getInstances(int modelID) throws KAONException {
        Connection connection=getConnection();
        try {
            AbstractObjectLoader loader=AbstractSQLObjectLoader.createSQLObjectLoader(connection,modelID,m_objectLoaderType);
            return loader.loadInstances();
        }
        finally {
            releaseConnection(connection);
        }
    }
    /**
     * @ejb.interface-method
     * @ejb.permission role-name="KAONWriter"
     */
    public KAONConnectionProxy.UpdateResultHolder updateOIModel(String initiatingConnectionIdentifier,List changeList) throws KAONException {
        try {
            Connection connection=getConnection();
            EngineeringServerDAO dao=null;
            try {
                dao=EngineeringServerDAO.createDAO(connection,m_daoType);
                ApplyChangeVisitor applyChangeVisitor=new ApplyChangeVisitor(dao);
                applyChangeVisitor.applyChanges(changeList);
                KAONConnectionProxy.UpdateResultHolder result=new KAONConnectionProxy.UpdateResultHolder();
                result.m_initiatingConnectionIdentifier=initiatingConnectionIdentifier;
                result.m_updatedChangeList=changeList;
                result.m_updatedConceptIDs=applyChangeVisitor.getUpdatedConceptIDs();
                result.m_updatedPropertyIDs=applyChangeVisitor.getUpdatedPropertyIDs();
                result.m_updatedInstanceIDs=applyChangeVisitor.getUpdatedInstanceIDs();
                m_changeBroadcaster.updateNotify(result);
                return result;
            }
            finally {
                if (dao!=null)
                    dao.close();
                releaseConnection(connection);
            }
        }
        catch (KAONException e) {
            m_sessionContext.setRollbackOnly();
            throw e;
        }
        catch (SQLException e) {
            m_sessionContext.setRollbackOnly();
            throw new KAONException("SQL error",e);
        }
    }
    /**
     * @ejb.interface-method
     * @ejb.permission role-name="KAONWriter"
     */
    public void setAttribute(int modelID,String key,String value) throws KAONException {
        try {
            Connection connection=getConnection();
            EngineeringServerDAO dao=null;
            try {
                dao=EngineeringServerDAO.createDAO(connection,m_daoType);
                dao.getOIModelDAO().setOIModelAttribute(modelID,key,value);
            }
            finally {
                if (dao!=null)
                    dao.close();
                releaseConnection(connection);
            }
        }
        catch (KAONException e) {
            m_sessionContext.setRollbackOnly();
            throw e;
        }
        catch (SQLException e) {
            m_sessionContext.setRollbackOnly();
            throw new KAONException("Error in getting connection",e);
        }
    }
    /**
     * @ejb.interface-method
     * @ejb.permission role-name="KAONReader,KAONWriter"
     */
    public Map getAttributes(int modelID) throws KAONException {
        try {
            Connection connection=getConnection();
            EngineeringServerDAO dao=null;
            try {
                dao=EngineeringServerDAO.createDAO(connection,m_daoType);
                return dao.getOIModelDAO().getOIModelAttributes(modelID);
            }
            finally {
                if (dao!=null)
                    dao.close();
                releaseConnection(connection);
            }
        }
        catch (KAONException e) {
            m_sessionContext.setRollbackOnly();
            throw e;
        }
        catch (SQLException e) {
            m_sessionContext.setRollbackOnly();
            throw new KAONException("Error in getting connection",e);
        }
    }
    /**
     * Returns the connection to the database.
     *
     * @return                              the connection to the databse
     * @throws KAONException                thrown if the connection cannot be obtained
     */
    protected Connection getConnection() throws KAONException {
        try {
            Context context=new InitialContext();
            DataSource dataSource=(DataSource)context.lookup("java:/KAON");
            return dataSource.getConnection();
        }
        catch (NamingException e) {
            throw new KAONException("Error obtaining data source",e);
        }
        catch (SQLException e) {
            throw new KAONException("SQL error",e);
        }
    }
    /**
     * Releases the connection.
     *
     * @param connection                    the connection
     * @throws KAONException                thrown if there is an error
     */
    protected void releaseConnection(Connection connection) throws KAONException {
        try {
            connection.close();
        }
        catch (SQLException e) {
            throw new KAONException("SQL error",e);
        }
    }
    /**
     * Returns a datalog manager for given model ID.
     *
     * @param modelID                       the ID of the model
     * @return                              the datalog manager for given model ID
     */
    protected DatalogManager getDatalogManager(int modelID) {
        Integer key=new Integer(modelID);
        DatalogManager datalogManager=(DatalogManager)m_datalogManagers.get(key);
        if (datalogManager==null) {
            datalogManager=new DatalogManager();
            datalogManager.registerExtensionalDatabase(ENGINEERING_SERVER_EXTENSIONAL_DATABASE_KEY,new EngineeringServerExtensionalDatabase(modelID));
            datalogManager.registerExtensionalDatabase(TEMPORARY_PREDICATES_EXTENSIONAL_DATABASE_KEY,new MemoryExtensionalDatabase());
            m_datalogManagers.put(key,datalogManager);
        }
        return datalogManager;
    }
}
