package edu.unika.aifb.kaon.engineeringserver.dao;

import java.sql.SQLException;

/**
 * DAO for PropertyRange objects.
 */
public class PropertyRangeDAO extends AbstractRelationshipDAO {
    /**
     * Creates an instance of this class.
     *
     * @param engineeringServerDAO          the engineering server DAO
     */
    public PropertyRangeDAO(EngineeringServerDAO engineeringServerDAO) {
        super(engineeringServerDAO);
    }
    /**
     * Creates a concept hierarchy object.
     *
     * @param modelID                       the ID of the model
     * @param property                      the property
     * @param concept                       the concept
     * @throws SQLException                 thrown if there is an error
     */
    public void createPropertyRange(int modelID,OIModelEntity property,OIModelEntity concept) throws SQLException {
        addRelationship(modelID,property,concept);
    }
    /**
     * Deletes a concept hierarchy object.
     *
     * @param modelID                       the ID of the model
     * @param property                      the property
     * @param concept                       the concept
     * @throws SQLException                 thrown if there is an error
     */
    public void deletePropertyRange(int modelID,OIModelEntity property,OIModelEntity concept) throws SQLException {
        removeRelationship(modelID,property,concept);
    }
    /**
     * The SQL statement for creating relationships.
     *
     * @return                              the SQL statement for creating relationships
     */
    protected String getAddRelationshipsSQL() {
        return "INSERT INTO PropertyRange (modelID,propertyID,conceptID) VALUES (?,?,?)";
    }
    /**
     * The SQL statement for removing relationships.
     *
     * @return                              the SQL statement for removing relationships
     */
    protected String getRemoveRelationshipsSQL() {
        return "DELETE FROM PropertyRange WHERE modelID=? AND propertyID=? AND conceptID=?";
    }
}
