package edu.unika.aifb.kaon.engineeringserver.dao;

import java.sql.SQLException;

/**
 * DAO for PropertyHierarchy objects.
 */
public class PropertyHierarchyDAO extends AbstractRelationshipDAO {
    /**
     * Creates an instance of this class.
     *
     * @param engineeringServerDAO          the engineering server DAO
     */
    public PropertyHierarchyDAO(EngineeringServerDAO engineeringServerDAO) {
        super(engineeringServerDAO);
    }
    /**
     * Creates a concept hierarchy object.
     *
     * @param modelID                       the ID of the model
     * @param superProperty                 the superproperty
     * @param subProperty                   the subproperty
     * @throws SQLException                 thrown if there is an error
     */
    public void createPropertyHierarchy(int modelID,OIModelEntity superProperty,OIModelEntity subProperty) throws SQLException {
        addRelationship(modelID,superProperty,subProperty);
    }
    /**
     * Deletes a concept hierarchy object.
     *
     * @param modelID                       the ID of the model
     * @param superProperty                 the superconcept
     * @param subProperty                   the subproperty
     * @throws SQLException                 thrown if there is an error
     */
    public void deletePropertyHierarchy(int modelID,OIModelEntity superProperty,OIModelEntity subProperty) throws SQLException {
        removeRelationship(modelID,superProperty,subProperty);
    }
    /**
     * The SQL statement for creating relationships.
     *
     * @return                              the SQL statement for creating relationships
     */
    protected String getAddRelationshipsSQL() {
        return "INSERT INTO PropertyHierarchy (modelID,superPropertyID,subPropertyID) VALUES (?,?,?)";
    }
    /**
     * The SQL statement for removing relationships.
     *
     * @return                              the SQL statement for removing relationships
     */
    protected String getRemoveRelationshipsSQL() {
        return "DELETE FROM PropertyHierarchy WHERE modelID=? AND superPropertyID=? AND subPropertyID=?";
    }
}
