package edu.unika.aifb.kaon.engineeringserver.dao;

/**
 * Represents an server OI-model entity.
 */
public class OIModelEntity {
    /** Set to <code>true</code> if this object was changed. */
    protected boolean m_isChanged;
    /** The ID of the model of this entity. */
    protected int m_modelID;
    /** The ID of the entity. */
    protected int m_entityID;
    /** The URI of the entity. */
    protected String m_entityURI;
    /** The concept version. */
    protected int m_conceptVersion=Integer.MAX_VALUE;
    /** The property version. */
    protected int m_propertyVersion=Integer.MAX_VALUE;
    /** Set to <code>true</code> if this property is attribute. */
    protected boolean m_isAttribute;
    /** Set to <code>true</code> if this property is symmetric. */
    protected boolean m_isSymmetric;
    /** Set to <code>true</code> if this property is transitive. */
    protected boolean m_isTransitive;
    /** The instance version. */
    protected int m_instanceVersion=Integer.MAX_VALUE;

    /**
     * Creates an instance of this class.
     *
     * @param modelID                       the ID of the model
     * @param entityURI                     the URI of the entity
     */
    public OIModelEntity(int modelID,String entityURI) {
        this(modelID,0,entityURI);
    }
    /**
     * Creates an instance of this class.
     *
     * @param modelID                       the ID of the model
     * @param entityID                      the ID of the entity
     * @param entityURI                     the URI of the entity
     */
    public OIModelEntity(int modelID,int entityID,String entityURI) {
        resetObjectChanged();
        m_modelID=modelID;
        m_entityID=entityID;
        m_entityURI=entityURI;
    }
    /**
     * Returns the ID of the model.
     *
     * @return                              the ID of the model
     */
    public int getModelID() {
        return m_modelID;
    }
    /**
     * Returns the ID of the entity ID.
     *
     * @return                              the ID of the entity
     */
    public int getEntityID() {
        return m_entityID;
    }
    /**
     * Sets the ID of the entity.
     *
     * @param entityID                      the ID of the entity
     */
    public void setEntityID(int entityID) {
        m_entityID=entityID;
    }
    /**
     * Returns the URI of the entity.
     *
     * @return                              the URI of the entity
     */
    public String getEntityURI() {
        return m_entityURI;
    }
    /**
     * Returns the version of the entity viewed as concept
     * (or Integer.MAX_VALUE if the concept is not in the model).
     *
     * @return                              the version of the entity viewed as concept
     */
    public int getConceptVersion() {
        return m_conceptVersion;
    }
    /**
     * Sets the version of the entity viewed as concept.
     *
     * @param conceptVersion                the version of the entity viewed as concept
     */
    public void setConceptVersion(int conceptVersion) {
        m_conceptVersion=conceptVersion;
        objectChanged();
    }
    /**
     * Returns the version of the entity viewed as property
     * (or Integer.MAX_VALUE if the property is not in the model).
     *
     * @return                              the version of the entity viewed as property
     */
    public int getPropertyVersion() {
        return m_propertyVersion;
    }
    /**
     * Sets the version of the entity viewed as property.
     *
     * @param propertyVersion               the version of the entity viewed as property
     */
    public void setPropertyVersion(int propertyVersion) {
        m_propertyVersion=propertyVersion;
        objectChanged();
    }
    /**
     * Returns <code>true</code> if this property is an attribute.
     *
     * @return                              <code>true</code> if this property is an attribute
     */
    public boolean getIsAttribute() {
        return m_isAttribute;
    }
    /**
     * Determines whether this property is an attribute.
     *
     * @param isAttribute                   <code>true</code> if this property is an attribute
     */
    public void setIsAttribute(boolean isAttribute) {
        m_isAttribute=isAttribute;
        objectChanged();
    }
    /**
     * Returns <code>true</code> if this property is symmetric.
     *
     * @return                              <code>true</code> if this property is symmetric
     */
    public boolean getIsSymmetric() {
        return m_isSymmetric;
    }
    /**
     * Determines whether this property is symmetric.
     *
     * @param isSymmetric                   <code>true</code> if this property is symmetric
     */
    public void setIsSymmetric(boolean isSymmetric) {
        m_isSymmetric=isSymmetric;
        objectChanged();
    }
    /**
     * Returns <code>true</code> if this property is transitive.
     *
     * @return                              <code>true</code> if this property is transitive
     */
    public boolean getIsTransitive() {
        return m_isTransitive;
    }
    /**
     * Determines whether this property is transitive.
     *
     * @param isTransitive                  <code>true</code> if this property is transitive
     */
    public void setIsTransitive(boolean isTransitive) {
        m_isTransitive=isTransitive;
        objectChanged();
    }
    /**
     * Returns the version of the entity viewed as instance
     * (or Integer.MAX_VALUE if the property is not in the model).
     *
     * @return                              the version of the entity viewed as instance
     */
    public int getInstanceVersion() {
        return m_instanceVersion;
    }
    /**
     * Sets the version of the entity viewed as instance.
     *
     * @param instanceVersion               the version of the entity viewed as instance
     */
    public void setInstanceVersion(int instanceVersion) {
        m_instanceVersion=instanceVersion;
        objectChanged();
    }
    /**
     * Returns <code>true</code> if this object was changed.
     *
     * @return                              <code>true</code> if this object was changed
     */
    public boolean isChanged() {
        return m_isChanged;
    }
    /**
     * Marks this object changed.
     */
    public void objectChanged() {
        m_isChanged=true;
    }
    /**
     * Marks this object not changed.
     */
    public void resetObjectChanged() {
        m_isChanged=false;
    }
    /**
     * Returns <code>true</code> if this entity has been created but not saved.
     *
     * @return                              <code>true</code> if the entity was created but not saved
     */
    public boolean isCreatedButNotSaved() {
        return m_entityID==0;
    }
    /**
     * Returns <code>true</code> if this entity could be deleted.
     *
     * @return                              <code>true</code> if this entity could be deleted
     */
    public boolean canBeDeleted() {
        return m_conceptVersion==Integer.MAX_VALUE && m_propertyVersion==Integer.MAX_VALUE && m_instanceVersion==Integer.MAX_VALUE;
    }
}
