package edu.unika.aifb.kaon.engineeringserver.dao;

import java.sql.SQLException;

/**
 * DAO for InverseProperty objects.
 */
public class InversePropertyDAO extends AbstractRelationshipDAO {
    /**
     * Creates an instance of this class.
     *
     * @param engineeringServerDAO          the engineering server DAO
     */
    public InversePropertyDAO(EngineeringServerDAO engineeringServerDAO) {
        super(engineeringServerDAO);
    }
    /**
     * Creates an inverse property object.
     *
     * @param modelID                       the ID of the model
     * @param property                      the property
     * @param inverseProperty               the inverse property
     * @throws SQLException                 thrown if there is an error
     */
    public void createInverseProperty(int modelID,OIModelEntity property,OIModelEntity inverseProperty) throws SQLException {
        addRelationship(modelID,property,inverseProperty);
    }
    /**
     * Deletes an inverse propert object.
     *
     * @param modelID                       the ID of the model
     * @param property                      the property
     * @param inverseProperty               the inverse property
     * @throws SQLException                 thrown if there is an error
     */
    public void deleteInverseProperty(int modelID,OIModelEntity property,OIModelEntity inverseProperty) throws SQLException {
        removeRelationship(modelID,property,inverseProperty);
    }
    /**
     * The SQL statement for creating relationships.
     *
     * @return                              the SQL statement for creating relationships
     */
    protected String getAddRelationshipsSQL() {
        return "INSERT INTO InverseProperty (modelID,propertyID,inversePropertyID) VALUES (?,?,?)";
    }
    /**
     * The SQL statement for removing relationships.
     *
     * @return                              the SQL statement for removing relationships
     */
    protected String getRemoveRelationshipsSQL() {
        return "DELETE FROM InverseProperty WHERE modelID=? AND propertyID=? AND inversePropertyID=?";
    }
}
