package edu.unika.aifb.kaon.engineeringserver.dao;

import java.sql.SQLException;

/**
 * DAO for ConceptInstance objects.
 */
public class ConceptInstanceDAO extends AbstractRelationshipDAO {
    /**
     * Creates an instance of this class.
     *
     * @param engineeringServerDAO          the engineering server DAO
     */
    public ConceptInstanceDAO(EngineeringServerDAO engineeringServerDAO) {
        super(engineeringServerDAO);
    }
    /**
     * Creates a concept hierarchy object.
     *
     * @param modelID                       the ID of the model
     * @param concept                       the concept
     * @param instance                      the instance
     * @throws SQLException                 thrown if there is an error
     */
    public void createConceptInstance(int modelID,OIModelEntity concept,OIModelEntity instance) throws SQLException {
        addRelationship(modelID,concept,instance);
    }
    /**
     * Deletes a concept hierarchy object.
     *
     * @param modelID                       the ID of the model
     * @param concept                       the concept
     * @param instance                      the instance
     * @throws SQLException                 thrown if there is an error
     */
    public void deleteConceptInstance(int modelID,OIModelEntity concept,OIModelEntity instance) throws SQLException {
        removeRelationship(modelID,concept,instance);
    }
    /**
     * The SQL statement for creating relationships.
     *
     * @return                              the SQL statement for creating relationships
     */
    protected String getAddRelationshipsSQL() {
        return "INSERT INTO ConceptInstance (modelID,conceptID,instanceID) VALUES (?,?,?)";
    }
    /**
     * The SQL statement for removing relationships.
     *
     * @return                              the SQL statement for removing relationships
     */
    protected String getRemoveRelationshipsSQL() {
        return "DELETE FROM ConceptInstance WHERE modelID=? AND conceptID=? AND instanceID=?";
    }
}
