package edu.unika.aifb.kaon.engineeringserver.dao;

import java.sql.SQLException;

/**
 * DAO for ConceptHierarchy objects.
 */
public class ConceptHierarchyDAO extends AbstractRelationshipDAO {
    /**
     * Creates an instance of this class.
     *
     * @param engineeringServerDAO          the engineering server DAO
     */
    public ConceptHierarchyDAO(EngineeringServerDAO engineeringServerDAO) {
        super(engineeringServerDAO);
    }
    /**
     * Creates a concept hierarchy object.
     *
     * @param modelID                       the ID of the model
     * @param superConcept                  the superconcept
     * @param subConcept                    the subConcept
     * @throws SQLException                 thrown if there is an error
     */
    public void createConceptHierarchy(int modelID,OIModelEntity superConcept,OIModelEntity subConcept) throws SQLException {
        addRelationship(modelID,superConcept,subConcept);
    }
    /**
     * Deletes a concept hierarchy object.
     *
     * @param modelID                       the ID of the model
     * @param superConcept                  the superconcept
     * @param subConcept                    the subConcept
     * @throws SQLException                 thrown if there is an error
     */
    public void deleteConceptHierarchy(int modelID,OIModelEntity superConcept,OIModelEntity subConcept) throws SQLException {
        removeRelationship(modelID,superConcept,subConcept);
    }
    /**
     * The SQL statement for creating relationships.
     *
     * @return                              the SQL statement for creating relationships
     */
    protected String getAddRelationshipsSQL() {
        return "INSERT INTO ConceptHierarchy (modelID,superConceptID,subConceptID) VALUES (?,?,?)";
    }
    /**
     * The SQL statement for removing relationships.
     *
     * @return                              the SQL statement for removing relationships
     */
    protected String getRemoveRelationshipsSQL() {
        return "DELETE FROM ConceptHierarchy WHERE modelID=? AND superConceptID=? AND subConceptID=?";
    }
}
