package edu.unika.aifb.kaon.engineeringserver.client;

import java.util.Map;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.apiproxy.source.*;

/**
 * The OI-model source that uses the server through local interfaces.
 */
public class LocalEngineeringSource implements OIModelSource {
    /** The logical URI of this model. */
    protected String m_logicalURI;
    /** The physical URI of this model. */
    protected String m_physicalURI;
    /** The ID of the model. */
    protected int m_modelID;
    /** The KAON Connection for this source. */
    protected LocalKAONConnection m_kaonConnection;

    /**
     * Creates an instance of this  class.
     *
     * @param serverPhysicalURI             the physical URI of the server
     * @param modelID                       the ID of the model
     * @param kaonConnection                the KAON connection
     * @throws KAONException                thrown if the model cannot be opened
     */
    public LocalEngineeringSource(String serverPhysicalURI,int modelID,LocalKAONConnection kaonConnection) throws KAONException {
        m_modelID=modelID;
        m_kaonConnection=kaonConnection;
        m_logicalURI=m_kaonConnection.getEngineeringServer().getOIModelLogicalURI(m_modelID);
        m_physicalURI=serverPhysicalURI+"?"+m_logicalURI;
    }
    /**
     * Returns the logical URI of this source.
     *
     * @return                              the logical URI of this source
     */
    public String getLogicalURI() {
        return m_logicalURI;
    }
    /**
     * Returns the physical URI of this source.
     *
     * @return                              the physical URI of this source
     */
    public String getPhysicalURI() {
        return m_physicalURI;
    }
    /**
     * Called to load information about specified entities.
     *
     * @param entityURIs                    an array of entity URIs to load
     * @param loadFlag                      the flag specifying what to load
     * @return                              information about loaded entities
     * @throws KAONException                thrown if there is a problem with fetching information
     */
    public EntityInfo[] loadEntities(String[] entityURIs,int loadFlag) throws KAONException {
        return m_kaonConnection.getEngineeringServer().loadEntities(m_modelID,entityURIs,loadFlag);
    }
    /**
     * Checks whether given instance is connected to specified value through a specified property.
     *
     * @param instanceURI                   the URI of the instance from which the check is made
     * @param propertyURI                   the URI of the property
     * @param targetInstanceURI             the URI of the target instance
     * @param targetValue                   the target value
     * @return                              <code>true</code> if this instance points to given value through given property (by including all inferred facts)
     * @throws KAONException                thrown if the check can't be performed
     */
    public boolean pointsToValue(String instanceURI,String propertyURI,String targetInstanceURI,Object targetValue) throws KAONException {
        return m_kaonConnection.getEngineeringServer().pointsToValue(m_modelID,instanceURI,propertyURI,targetInstanceURI,targetValue);
    }
    /**
     * Returns the information about all property instances connected to given instance, possibly filtered through given property.
     *
     * @param instanceURI                   the URI of the instance for which property instances are loaded
     * @param propertyURI                   the URI of the property for which property instances are loaded
     * @return                              equal to the structure of <code>InstanceInfo.m_propertyValuesFrom</code>
     * @throws KAONException                thrown if the property instances can't be determined
     */
    public Object[][] getAllFromPropertyValues(String instanceURI,String propertyURI) throws KAONException {
        return m_kaonConnection.getEngineeringServer().getAllFromPropertyValues(m_modelID,instanceURI,propertyURI);
    }
    /**
     * Returns the information about all property instances pointing from given instance, possibly filtered through given property.
     *
     * @param instanceURI                   the URI of the instance from which property instances are loaded
     * @param propertyURI                   the URI of the property for which property instances are loaded (may be <code>null</code>)
     * @return                              equal to the structure of <code>InstanceInfo.m_propertyValuesTo</code>
     * @throws KAONException                thrown if the property instances can't be determined
     */
    public Object[][] getAllToPropertyValues(String instanceURI,String propertyURI) throws KAONException {
        return m_kaonConnection.getEngineeringServer().getAllToPropertyValues(m_modelID,instanceURI,propertyURI);
    }
    /**
     * Returns the list of IDs of all concepts.
     *
     * @return                              the list of all IDs of concepts
     * @throws KAONException                thrown if there is a problem with fetching information
     */
    public EntityID[] getConcepts() throws KAONException {
        return m_kaonConnection.getEngineeringServer().getConcepts(m_modelID);
    }
    /**
     * Returns the list of IDs of all properties.
     *
     * @return                              the list of all IDs of properties
     * @throws KAONException                thrown if there is a problem with fetching information
     */
    public EntityID[] getProperties() throws KAONException {
        return m_kaonConnection.getEngineeringServer().getProperties(m_modelID);
    }
    /**
     * Returns the list of IDs of all instances.
     *
     * @return                              the list of all IDs of instances
     * @throws KAONException                thrown if there is a problem with fetching information
     */
    public EntityID[] getInstances() throws KAONException {
        return m_kaonConnection.getEngineeringServer().getInstances(m_modelID);
    }
    /**
     * Executes given query and returns the results.
     *
     * @param queryString                   the query being executed
     * @return                              the results of the query
     * @throws KAONException                thrown if there is an error executing the query
     */
    public Object[] executeQuery(String queryString) throws KAONException {
        return m_kaonConnection.getEngineeringServer().executeQuery(m_modelID,queryString);
    }
    /**
     * Deletes the model.
     *
     * @throws KAONException                thrown if there is a problem with fetching or updating information
     */
    public void deleteOIModel() throws KAONException {
        m_kaonConnection.getEngineeringServer().deleteOIModel(m_kaonConnection.getConnectionIdentifier(),m_modelID);
    }
    /**
     * Returns an OI-model for given model ID.
     *
     * @param modelID                       the ID of the OI-model
     * @return                              the OI-model with given ID
     * @throws KAONException                thrown if the ID cannot be translated into an OI-model
     */
    public OIModel getOIModel(int modelID) throws KAONException {
        return m_kaonConnection.getOIModel(modelID);
    }
    /**
     * Sets the attribute of the OI-model.
     *
     * @param key                           the key
     * @param value                         the value (or <code>null</code> if the attribute should be deleted)
     * @throws KAONException                thrown if the attribute cannot be set
     */
    public void setAttribute(String key,String value) throws KAONException {
        m_kaonConnection.getEngineeringServer().setAttribute(m_modelID,key,value);
    }
    /**
     * Returns the map of attributes of this OI-model.
     *
     * @return                              the map of attributes of the OI-model
     * @throws KAONException                thrown if the attributes cannot be read
     */
    public Map getAttributes() throws KAONException {
        return m_kaonConnection.getEngineeringServer().getAttributes(m_modelID);
    }
}
