CREATE TABLE PKCounter (
    type varchar (255) NOT NULL,
    counter int NOT NULL,
    CONSTRAINT pk_PKCounter PRIMARY KEY (type)
);

CREATE TABLE OIModel (
    modelID int NOT NULL,
    logicalURI varchar (255) NOT NULL,
    CONSTRAINT pk_OIModel PRIMARY KEY (modelID),
    CONSTRAINT logicalURI_OIModel UNIQUE (logicalURI)
);

CREATE TABLE IncludedOIModel (
    includingModelID int NOT NULL,
    includedModelID int NOT NULL,
    CONSTRAINT pk_IncludedOIModel PRIMARY KEY (includingModelID,includedModelID),
    CONSTRAINT f1_IncludedOIModel FOREIGN KEY (includingModelID) REFERENCES OIModel (modelID),
    CONSTRAINT f2_IncludedOIModel FOREIGN KEY (includedModelID) REFERENCES OIModel (modelID)
);

CREATE TABLE AllIncludedOIModels (
    includedModelID int NOT NULL,
    includingModelID int NOT NULL,
    CONSTRAINT pk_AllIncluded PRIMARY KEY (includingModelID,includedModelID),
    CONSTRAINT f1_AllIncluded FOREIGN KEY (includingModelID) REFERENCES OIModel (modelID),
    CONSTRAINT f2_AllIncluded FOREIGN KEY (includedModelID) REFERENCES OIModel (modelID)
);

CREATE TABLE OIModelAttribute (
    modelID int NOT NULL,
    attributeKey varchar (255) NOT NULL,
    attributeValue varchar (255) NOT NULL,
    CONSTRAINT pk_OIModelAttr PRIMARY KEY (modelID,attributeKey),
    CONSTRAINT f1_OIModelAttr FOREIGN KEY (modelID) REFERENCES OIModel (modelID)
);

CREATE TABLE OIModelEntity (
    entityID int NOT NULL,
    modelID int NOT NULL,
    entityURI varchar (255) NOT NULL,
    conceptVersion int NOT NULL,
    propertyVersion int NOT NULL,
    isAttribute smallint NOT NULL,
    isSymmetric smallint NOT NULL,
    isTransitive smallint NOT NULL,
    instanceVersion int NOT NULL,
    CONSTRAINT pk_OIModelEntity PRIMARY KEY (entityID),
    CONSTRAINT f1_OIModelEntity FOREIGN KEY (modelID) REFERENCES OIModel (modelID)
);

CREATE TABLE InverseProperty (
    modelID int NOT NULL,
    propertyID int NOT NULL,
    inversePropertyID int NOT NULL,
    CONSTRAINT pk_IProperty PRIMARY KEY (modelID,propertyID),
    CONSTRAINT f1_IProperty FOREIGN KEY (modelID) REFERENCES OIModel (modelID),
    CONSTRAINT f2_IProperty FOREIGN KEY (propertyID) REFERENCES OIModelEntity (entityID),
    CONSTRAINT f3_IProperty FOREIGN KEY (inversePropertyID) REFERENCES OIModelEntity (entityID)
);

CREATE TABLE ConceptHierarchy (
    modelID int NOT NULL,
    superConceptID int NOT NULL,
    subConceptID int NOT NULL,
    CONSTRAINT pk_CHierarchy PRIMARY KEY (modelID,superConceptID,subConceptID),
    CONSTRAINT f1_CHierarchy FOREIGN KEY (modelID) REFERENCES OIModel (modelID),
    CONSTRAINT f2_CHierarchy FOREIGN KEY (superConceptID) REFERENCES OIModelEntity (entityID),
    CONSTRAINT f3_CHierarchy FOREIGN KEY (subConceptID) REFERENCES OIModelEntity (entityID)
);

CREATE TABLE ConceptInstance (
    modelID int NOT NULL,
    conceptID int NOT NULL,
    instanceID int NOT NULL,
    CONSTRAINT pk_CInstance PRIMARY KEY (modelID,conceptID,instanceID),
    CONSTRAINT f1_CInstance FOREIGN KEY (modelID) REFERENCES OIModel (modelID),
    CONSTRAINT f2_CInstance FOREIGN KEY (conceptID) REFERENCES OIModelEntity (entityID),
    CONSTRAINT f3_CInstance FOREIGN KEY (instanceID) REFERENCES OIModelEntity (entityID)
);

CREATE TABLE PropertyHierarchy (
    modelID int NOT NULL,
    superPropertyID int NOT NULL,
    subPropertyID int NOT NULL,
    CONSTRAINT pk_PHierarchy PRIMARY KEY (modelID,superPropertyID,subPropertyID),
    CONSTRAINT f1_PHierarchy FOREIGN KEY (modelID) REFERENCES OIModel (modelID),
    CONSTRAINT f2_PHierarchy FOREIGN KEY (superPropertyID) REFERENCES OIModelEntity (entityID),
    CONSTRAINT f3_PHierarchy FOREIGN KEY (subPropertyID) REFERENCES OIModelEntity (entityID)
);

CREATE TABLE PropertyDomain (
    modelID int NOT NULL,
    propertyID int NOT NULL,
    conceptID int NOT NULL,
    minimumCardinality int NOT NULL,
    maximumCardinality int NOT NULL,
    CONSTRAINT pk_PDomain PRIMARY KEY (modelID,propertyID,conceptID),
    CONSTRAINT f1_PDomain FOREIGN KEY (modelID) REFERENCES OIModel (modelID),
    CONSTRAINT f2_PDomain FOREIGN KEY (propertyID) REFERENCES OIModelEntity (entityID),
    CONSTRAINT f3_PDomain FOREIGN KEY (conceptID) REFERENCES OIModelEntity (entityID)
);

CREATE TABLE PropertyRange (
    modelID int NOT NULL,
    propertyID int NOT NULL,
    conceptID int NOT NULL,
    CONSTRAINT pk_PRange PRIMARY KEY (modelID,propertyID,conceptID),
    CONSTRAINT f1_PRange FOREIGN KEY (modelID) REFERENCES OIModel (modelID),
    CONSTRAINT f2_PRange FOREIGN KEY (propertyID) REFERENCES OIModelEntity (entityID),
    CONSTRAINT f3_PRange FOREIGN KEY (conceptID) REFERENCES OIModelEntity (entityID)
);

CREATE TABLE RelationInstance (
    modelID int NOT NULL,
    propertyID int NOT NULL,
    sourceInstanceID int NOT NULL,
    targetInstanceID int NOT NULL,
    CONSTRAINT pk_RInstance PRIMARY KEY (modelID,propertyID,sourceInstanceID,targetInstanceID),
    CONSTRAINT f1_RInstance FOREIGN KEY (modelID) REFERENCES OIModel (modelID),
    CONSTRAINT f2_RInstance FOREIGN KEY (propertyID) REFERENCES OIModelEntity (entityID),
    CONSTRAINT f3_RInstance FOREIGN KEY (sourceInstanceID) REFERENCES OIModelEntity (entityID),
    CONSTRAINT f4_RInstance FOREIGN KEY (targetInstanceID) REFERENCES OIModelEntity (entityID)
);

CREATE TABLE AttributeInstance (
    modelID int NOT NULL,
    propertyID int NOT NULL,
    sourceInstanceID int NOT NULL,
    textValue varchar (255) NOT NULL,
    CONSTRAINT pk_AInstance PRIMARY KEY (modelID,propertyID,sourceInstanceID,textValue),
    CONSTRAINT f1_AInstance FOREIGN KEY (modelID) REFERENCES OIModel (modelID),
    CONSTRAINT f2_AInstance FOREIGN KEY (propertyID) REFERENCES OIModelEntity (entityID),
    CONSTRAINT f3_AInstance FOREIGN KEY (sourceInstanceID) REFERENCES OIModelEntity (entityID)
);

CREATE TABLE URIJoinTable (
    joinID numeric(19,0) NOT NULL,
    entityURI varchar (255) NOT NULL,
    CONSTRAINT pk_URIJoinTable PRIMARY KEY (joinID,entityURI)
);

CREATE INDEX AllIncluded_1 ON AllIncludedOIModels(includingModelID);

CREATE INDEX InverseProperty_1 ON InverseProperty(propertyID);
CREATE INDEX InverseProperty_2 ON InverseProperty(inversePropertyID);

CREATE INDEX ConceptHierarchy_1 ON ConceptHierarchy(subConceptID);
CREATE INDEX ConceptHierarchy_2 ON ConceptHierarchy(superConceptID);

CREATE INDEX ConceptInstance_1 ON ConceptInstance(conceptID);
CREATE INDEX ConceptInstance_2 ON ConceptInstance(instanceID);

CREATE INDEX PropertyDomain_1 ON PropertyDomain(propertyID);
CREATE INDEX PropertyDomain_2 ON PropertyDomain(conceptID);

CREATE INDEX PropertyRange_1 ON PropertyRange(propertyID);
CREATE INDEX PropertyRange_2 ON PropertyRange(conceptID);

CREATE INDEX PropHierarchy_1 ON PropertyHierarchy(subPropertyID);
CREATE INDEX PropHierarchy_2 ON PropertyHierarchy(superPropertyID);

CREATE INDEX RelInstance_1 ON RelationInstance(propertyID);
CREATE INDEX RelInstance_2 ON RelationInstance(sourceInstanceID);
CREATE INDEX RelInstance_3 ON RelationInstance(targetInstanceID);

CREATE INDEX AttrInstance_1 ON AttributeInstance(propertyID);
CREATE INDEX AttrInstance_2 ON AttributeInstance(sourceInstanceID);
CREATE INDEX AttrInstance_3 ON AttributeInstance(textValue);

CREATE INDEX OIModelEntity_1 ON OIModelEntity(entityURI);
CREATE INDEX OIModelEntity_2 ON OIModelEntity(modelID);
