package edu.unika.aifb.kaon.datalog.util;

import java.util.Map;
import java.util.HashMap;

import edu.unika.aifb.kaon.datalog.evaluation.*;
import edu.unika.aifb.kaon.datalog.magic.*;

/**
 * This class manages a set of extensional databases together with precompiled query plans that were created on these databases.
 */
public class DatalogManager extends ExtensionalManager {
    /** The map of all precompiled query evaluators indexed by some key. */
    protected Map m_queryEvaluators;
    /** The map of all magic set rewritings indexed by some key. */
    protected Map m_magicSetRewritings;

    /**
     * Creates an instance of this class.
     */
    public DatalogManager() {
        m_queryEvaluators=new HashMap();
        m_magicSetRewritings=new HashMap();
    }
    /**
     * Returns the query evaluator for given name.
     *
     * @param evaluatorName                 the name of the query evaluator
     * @return                              the query evaluator for given name (or <code>null</code> if such an evaluator doesn't exist)
     */
    public Evaluator getEvaluator(String evaluatorName) {
        return (Evaluator)m_queryEvaluators.get(evaluatorName);
    }
    /**
     * Returns the magic sets rewriting for given name.
     *
     * @param evaluatorName                 the name of the query evaluator
     * @return                              the magic sets rewriting with given name (or <code>null</code> if there is no such information)
     */
    public MagicSetRewriting getMagicSetRewriting(String evaluatorName) {
        return (MagicSetRewriting)m_magicSetRewritings.get(evaluatorName);
    }
    /**
     * Registers an evaluator for given name.
     *
     * @param evaluatorName                 the name of the query evaluator
     * @param evaluator                     the query evaluator (or <code>null</code> if the evaluator should be removed)
     * @param magicSetRewriting             the magic set rewriting for the evaluator (may be <code>null</code>)
     */
    public void registerEvaluator(String evaluatorName,Evaluator evaluator,MagicSetRewriting magicSetRewriting) {
        if (evaluator==null) {
            m_queryEvaluators.remove(evaluatorName);
            m_magicSetRewritings.remove(evaluatorName);
        }
        else {
            m_queryEvaluators.put(evaluatorName,evaluator);
            m_magicSetRewritings.put(evaluatorName,magicSetRewriting);
        }
    }
}
