package edu.unika.aifb.kaon.datalog.program;

/**
 * Represents a variable in a literal.
 */
public class Variable implements Term {
    /** The counter for the unnamed variables. */
    protected static volatile int s_unnamedVariableCounter;

    /** The name of the variable. */
    protected String m_variableName;

    /**
     * Creates a variable.
     *
     * @param variableName                      the name of the variable
     */
    public Variable(String variableName) {
        if ("_".equals(variableName))
            m_variableName="_unnamed"+(s_unnamedVariableCounter++);
        else
            m_variableName=variableName;
    }
    /**
     * Returns the name of this variable.
     *
     * @return                                  the name of this variable
     */
    public String getVariableName() {
        return m_variableName;
    }
    /**
     * Returns the depth of this term.
     *
     * @return                                  the depth of the term
     */
    public int getDepth() {
        return 0;
    }
    /**
     * Converts this variable to a string.
     *
     * @return                                  the string representation of the variable
     */
    public String toString() {
        return m_variableName;
    }
    /**
     * Checks if this variable is equal to some other variable.
     *
     * @param other                             the other object
     * @return                                  <code>true</code> if this variable is equal to some other variable
     */
    public boolean equals(Object other) {
        if (this==other)
            return true;
        if (!(other instanceof Variable))
            return false;
        return m_variableName.equals(((Variable)other).m_variableName);
    }
    /**
     * Returns the hash-code of this variable.
     *
     * @return                                  the hash-code of the variable
     */
    public int hashCode() {
        return m_variableName.hashCode();
    }
}
