package edu.unika.aifb.kaon.datalog.program;

/**
 * A term that represents the call of an unary function.
 */
public class UnaryFunctionCall implements Term {
    /** The name of the function. */
    protected String m_functionName;
    /** The argument term. */
    protected Term m_argument;

    /**
     * Creates an instance of this class.
     *
     * @param functionName              the name of the function
     * @param argument                  the argument of the function call
     */
    public UnaryFunctionCall(String functionName,Term argument) {
        m_functionName=functionName;
        m_argument=argument;
    }
    /**
     * Returns the name of the function.
     *
     * @return                          the name of the function
     */
    public String getFunctionName() {
        return m_functionName;
    }
    /**
     * Returns the argument of the function.
     *
     * @return                          the argument of the function
     */
    public Term getArgument() {
        return m_argument;
    }
    /**
     * Returns the most inner term of this function call.
     *
     * @return                                  the most inner term of the call
     */
    public Term getCallTerm() {
        Term term=this;
        while (term instanceof UnaryFunctionCall)
            term=((UnaryFunctionCall)term).getArgument();
        return term;
    }
    /**
     * Returns the depth of this term.
     *
     * @return                                  the depth of the term
     */
    public int getDepth() {
        return 1+m_argument.getDepth();
    }
    /**
     * Converts this variable to a string.
     *
     * @return                                  the string representation of the variable
     */
    public String toString() {
        return m_functionName+"("+m_argument.toString()+")";
    }
    /**
     * Checks if this variable is equal to some other variable.
     *
     * @param other                             the other object
     * @return                                  <code>true</code> if this variable is equal to some other variable
     */
    public boolean equals(Object other) {
        if (this==other)
            return true;
        if (!(other instanceof UnaryFunctionCall))
            return false;
        UnaryFunctionCall otherUnaryFunctionCall=(UnaryFunctionCall)other;
        return m_functionName.equals(otherUnaryFunctionCall.m_functionName) && m_argument.equals(otherUnaryFunctionCall.m_argument);
    }
    /**
     * Returns the hash-code of this variable.
     *
     * @return                                  the hash-code of the variable
     */
    public int hashCode() {
        return m_functionName.hashCode()*7+m_argument.hashCode();
    }
}
