package edu.unika.aifb.kaon.datalog.program;

/**
 * Represents an logic program consisting of a set of rules. The ground facts
 * are not a part of the program.
 */
public class Program {
    /** The array of rules in the program. */
    protected Rule[] m_rules;

    /**
     * Creates an instance of this class.
     *
     * @param rules                         the array of rules in the program
     */
    public Program(Rule[] rules) {
        m_rules=rules;
    }
    /**
     * Returns the number of rules in the program.
     *
     * @return                              the number of rules in the program
     */
    public int getNumberOfRules() {
        return m_rules.length;
    }
    /**
     * Returns the given rule in the program.
     *
     * @param ruleIndex                     the index of the rule
     * @return                              the rule with given index
     */
    public Rule getRule(int ruleIndex) {
        return m_rules[ruleIndex];
    }
    /**
     * Returns <code>true</code> if this program contains only Horn rules with one head literal.
     *
     * @return                              <code>true</code> if this Horn program with one head literal
     */
    public boolean isHorn() {
        for (int i=0;i<m_rules.length;i++)
            if (!m_rules[i].isHorn())
                return false;
        return true;
    }
    /**
     * Returns a string representation of this program.
     *
     * @return                              the string representation of the program
     */
    public String toString() {
        String lineSeparator=System.getProperty("line.separator");
        StringBuffer buffer=new StringBuffer();
        for (int i=0;i<m_rules.length;i++) {
            buffer.append(m_rules[i].toString());
            buffer.append(lineSeparator);
        }
        return buffer.toString();
    }
}
