package edu.unika.aifb.kaon.datalog.program;

/**
 * Defines which bindings patterns are allowed for which predicates. This information can be used to order the predicates in the body
 * of the rule so that no predicate is invoked with invalid binding patterns.
 */
public interface PredicateBindingPatterns {
    /**
     * Determines whether given binding pattern is allowed for given predicate.
     *
     * @param predicate                         the predicate
     * @param boundValues                       the bound values
     * @return                                  <code>true</code> if given binding pattern is allowed for given predicate
     */
    boolean isBindingPatternAllowed(Predicate predicate,boolean[] boundValues);

    /** A default implementation of this inteface which allows any binding pattern for any predicate. */
    static final PredicateBindingPatterns ALL_BINDING_PATTERNS_ALLOWED=new PredicateBindingPatterns() {
        public boolean isBindingPatternAllowed(Predicate predicate,boolean[] boundValues) {
            return true;
        }
    };
}
