package edu.unika.aifb.kaon.datalog.program;

/**
 * Represents a constant in a literal.
 */
public class Constant implements Term {
    /** The NULL constant. */
    public static final Constant NULL=new Constant(null);

    /** The value of the constant. */
    protected Object m_value;

    /**
     * Creates a null constant.
     */
    public Constant() {
        this(null);
    }
    /**
     * Creates a constant.
     *
     * @param value                             the value of the constant
     */
    public Constant(Object value) {
        m_value=value;
    }
    /**
     * Creates a constant.
     *
     * @param value                             the boolean value of the constant
     */
    public Constant(boolean value) {
        m_value=value ? Boolean.TRUE : Boolean.FALSE;
    }
    /**
     * Creates a constant.
     *
     * @param value                             the integer value of the constant
     */
    public Constant(int value) {
        m_value=new Integer(value);
    }
    /**
     * Returns the value of the constant.
     *
     * @return                                  the value of the constant
     */
    public Object getValue() {
        return m_value;
    }
    /**
     * Returns the depth of this term.
     *
     * @return                                  the depth of the term
     */
    public int getDepth() {
        return 0;
    }
    /**
     * Converts this constant to a string.
     *
     * @return                                  the string representation of the constant
     */
    public String toString() {
        if (m_value==null)
            return "<null>";
        else if (m_value instanceof String)
            return '"'+m_value.toString()+'"';
        else if (m_value instanceof Boolean)
            return '['+m_value.toString()+']';
        else
            return m_value.toString();
    }
    /**
     * Checks if this constant is equal to some other constant.
     *
     * @param other                             the other constant
     * @return                                  <code>true</code> if this constant is equal to some other constant
     */
    public boolean equals(Object other) {
        if (this==other)
            return true;
        if (!(other instanceof Constant))
            return false;
        Object otherValue=((Constant)other).m_value;
        return m_value==otherValue || (m_value!=null && m_value.equals(otherValue));
    }
    /**
     * Returns the hash-code of this variable.
     *
     * @return                                  the hash-code of the variable
     */
    public int hashCode() {
        return m_value==null ? 0 : m_value.hashCode();
    }
}
