package edu.unika.aifb.kaon.datalog.parser;

import edu.unika.aifb.kaon.datalog.program.*;
import edu.unika.aifb.kaon.datalog.evaluation.*;
import java.util.List;
/**
 * Receives information from the parser.
 */
public interface DatalogParserConsumer {
    /**
     * Returns the predicate for given paramters.
     *
     * @param isPositive                        <code>true</code> if predicate is classically positive
     * @param name                              the name of the predicate (without positive/negative status and arity)
     * @param arity                             the arity of the predicate
     * @return                                  the predicate
     * @throws ParseException                   thrown if parsing should be stopped
     */
    Predicate getPredicate(boolean isPositive,String name,int arity) throws ParseException;
    /**
     * Called when parsing is started.
     *
     * @throws ParseException                   thrown if parsing should be stopped
     */
    void startParsing() throws ParseException;
    /**
     * Called when parsing is done.
     *
     * @throws ParseException                   thrown if parsing should be stopped
     */
    void doneParsing() throws ParseException;
    /**
     * Called when a rule has been parsed.
     *
     * @param rule                              the rule
     * @throws ParseException                   thrown if parsing should be stopped
     */
    void consumeRule(Rule rule) throws ParseException;
    /**
     * Called when a fact has been parsed.
     *
     * @param disjunction                       the disjunction
     * @throws ParseException                   thrown if parsing should be stopped
     */
    void consumeFact(LiteralValue[] disjunction) throws ParseException;
    /**
     * Returns the list of all rules
     *
     */
    List getRules();   
}
