package edu.unika.aifb.kaon.datalog.magic;

import java.util.Set;

import edu.unika.aifb.kaon.datalog.*;
import edu.unika.aifb.kaon.datalog.program.*;

/**
 * A SIPS (sideways information passing strategy) represents a strategy for passing infromation within literals of rules.
 */
public interface SIPS {
    /**
     * Creates an adorned program from given program.
     *
     * @param program                               the program
     * @param queryPredicate                        the predicate of the query
     * @param boundVariables                        the bound variables
     * @param additionalFreePredicates              the set of predicates that are additionally invoked as free
     * @param idbPredicates                         the set of IDB predicates in the program
     * @param predicateBindingPatterns              determines allowed binding patterns of a predicate
     * @return                                      the adorned program
     * @throws DatalogException                     thrown if there is no valid rewriting for a program
     */
    AdornedRuleInfo[] adornProgram(Program program,Predicate queryPredicate,boolean[] boundVariables,Set additionalFreePredicates,Set idbPredicates,PredicateBindingPatterns predicateBindingPatterns) throws DatalogException;

    /**
     * Holds the information about the adornment of the literal.
     */
    public static class AdornationInfo {
        /** The literal being adorned. */
        public Literal m_literal;
        /** The array defining the bindings of the variables. It is <code>null</code> if the predicate is an EDB predicate or if this literal doesn't preticipate in SIPS. Only positions in literals that have variables should be marked as bound. */
        public boolean[] m_boundVariables;
        /** Set to <code>true</code> if for this literal there is an incoming arc in the SIPS, meaning that there is some information passed to it. */
        public boolean m_hasIncomingArc;

        public AdornationInfo(Literal literal,boolean[] boundVariables,boolean hasIncomingArc) {
            m_literal=literal;
            m_boundVariables=boundVariables;
            m_hasIncomingArc=hasIncomingArc;
        }
    }

    /**
     * Holds the information about the adorned rule.
     */
    public static class AdornedRuleInfo {
        /** The rule that was adorned. */
        public Rule m_rule;
        /** The information about adorination of rule's body head. */
        public AdornationInfo m_headAdornationInfo;
        /** The information about adorination of rule's body literals. */
        public AdornationInfo[] m_bodyAdornationInfos;

        public AdornedRuleInfo(Rule rule,AdornationInfo headAdornationInfo,AdornationInfo[] bodyAdornationInfos) {
            m_rule=rule;
            m_headAdornationInfo=headAdornationInfo;
            m_bodyAdornationInfos=bodyAdornationInfos;
        }
    }
}
