package edu.unika.aifb.kaon.datalog.jdbc;

import java.util.Iterator;

/**
 * Encapsulates the differences between various databases.
 */
public class DatabaseManager {
    /** The type manager. */
    protected TypeManager m_typeManager;

    /**
     * Creates an instance of this class.
     */
    public DatabaseManager() {
        m_typeManager=TypeManager.INSTANCE;
    }
    /**
     * Returns the type manager.
     *
     * @return                              the type manager
     */
    public TypeManager getTypeManager() {
        return m_typeManager;
    }
    /**
     * Sets the type manager.
     *
     * @param typeManager                   the type manager
     */
    public void setTypeManager(TypeManager typeManager) {
        m_typeManager=typeManager;
    }
    /**
     * Returns the name of the temporary table with given types of columns.
     *
     * @param columnTypes                   the types of the columns
     * @return                              the name of the table with given types of columns
     */
    public String getTemporaryTableName(int[] columnTypes) {
        return "TemporaryValues"+columnTypes.length;
    }
    /**
     * Returns the SQL statement for creating the temporary table with given types of columns.
     *
     * @param columnTypes                   the types of the columns
     * @return                              the statement for creating a temporary table with given types of columns (or <code>null</code> if table is part of the schema)
     */
    public String getCreateTempoararyTableSQL(int[] columnTypes) {
        return null;
    }
    /**
     * Returns the SQL statement for emptying the temporary table with given types of columns.
     *
     * @param columnTypes                   the types of the columns
     * @return                              the SQL statement for deleting the table
     */
    public String getEmptyTemporaryTableSQL(int[] columnTypes) {
        return "DELETE FROM "+getTemporaryTableName(columnTypes);
    }
    /**
     * Returns the SQL statement for destroying the temporary table with given types of columns.
     *
     * @param columnTypes                   the types of the columns
     * @return                              the SQL statement for deleting the table
     */
    public String getDropTableSQL(int[] columnTypes) {
        return null;
    }
    /**
     * Checks whether this database should use the temporary table for passing bindings.
     *
     * @param numberOfBindings              the number of bindings
     * @param columnTypes                   the types of columns
     * @return                              <code>true</code> if temporary table should be used to pass bindings
     */
    public boolean passBindingsThroughTemporaryTable(int numberOfBindings,int[] columnTypes) {
        return true;
    }
    /**
     * If temporary table is not used, this method should modify the query with literals
     * that specify the bindings;
     *
     * @param columnTypes                   the types of columns
     * @param buildJoinIndices              the join indices of the build stream
     * @param boundValues                   the iterator specifying the bound values
     * @param originalQuery                 the original query
     * @return                              the modified query
     */
    public String modifyQueryWithBindings(int[] columnTypes,int[] buildJoinIndices,Iterator boundValues,String originalQuery) {
        return null;
    }
    /**
     * Returns <code>true</code> if model ID restriction should be placed as inner select.
     *
     * @return                              <code>true</code> if the model ID restriction should be placed as inner select
     */
    public boolean modelIDAsInnerSelect() {
        return false;
    }
}
