package edu.unika.aifb.kaon.datalog.evaluation;

/**
 * Implements the value of the call of an unary function over some other value.
 */
public class UnaryFunctionCallValue implements Comparable {
    /** The name of the unary function. */
    protected String m_functionName;
    /** The argument on which the function was called. */
    protected Object m_argument;
    /** The hash-code of this object. */
    protected int m_hashCode;

    /**
     * Creates an instance of this class.
     *
     * @param functionName                  the name of the function
     * @param argument                      the argument on which the function was called (may be <code>null</code>)
     */
    public UnaryFunctionCallValue(String functionName,Object argument) {
        m_functionName=functionName;
        m_argument=argument;
        m_hashCode=m_functionName.hashCode()*7+(m_argument==null ? 0 : m_argument.hashCode());
    }
    /**
     * Retruns the name of the function.
     *
     * @return                              the name of the function
     */
    public String getFunctionName() {
        return m_functionName;
    }
    /**
     * Returns the argument on which the function was called.
     *
     * @return                              the argument on which the function was called (may be <code>null</code>)
     */
    public Object getArgument() {
        return m_argument;
    }
    /**
     * Checks if this variable is equal to some other variable.
     *
     * @param other                             the other object
     * @return                                  <code>true</code> if this variable is equal to some other variable
     */
    public boolean equals(Object other) {
        if (this==other)
            return true;
        if (!(other instanceof UnaryFunctionCallValue))
            return false;
        UnaryFunctionCallValue otherUnaryFunctionCallValue=(UnaryFunctionCallValue)other;
        return m_functionName.equals(otherUnaryFunctionCallValue.m_functionName) && m_argument.equals(otherUnaryFunctionCallValue.m_argument);
    }
    /**
     * Returns the hash-code of this variable.
     *
     * @return                                  the hash-code of the variable
     */
    public int hashCode() {
        return m_hashCode;
    }
    /**
     * Compares this object to another object.
     *
     * @param other                             the other object
     * @return                                  the value of the comparison
     */
    public int compareTo(Object other) {
        if (!(other instanceof UnaryFunctionCallValue))
            return 1;
        UnaryFunctionCallValue otherUnaryFunctionCallValue=(UnaryFunctionCallValue)other;
        int result=m_functionName.compareTo(otherUnaryFunctionCallValue.m_functionName);
        if (result!=0)
            return result;
        if (!(m_argument instanceof Comparable) || !(otherUnaryFunctionCallValue.m_argument instanceof Comparable))
            return 0;
        if (m_argument instanceof UnaryFunctionCallValue)
            return ((Comparable)m_argument).compareTo(otherUnaryFunctionCallValue.m_argument);
        if (otherUnaryFunctionCallValue.m_argument instanceof UnaryFunctionCallValue)
            return -((Comparable)otherUnaryFunctionCallValue.m_argument).compareTo(m_argument);
        return ((Comparable)m_argument).compareTo(otherUnaryFunctionCallValue.m_argument);
    }
    /**
     * Converts this constant to string.
     *
     * @return                                  the string value of the constant
     */
    public String toString() {
        return m_functionName+"("+(m_argument==null ? "null" : m_argument.toString())+")";
    }
}
