package edu.unika.aifb.kaon.datalog.evaluation;

/**
 * This class can rearrange the input tuple into appropriate order and complement it with constants.
 */
public class TupleRename {
    /** The pairs of indices to copy for each source. */
    protected int[][] m_indicesToCopy;
    /** The constant values to copy. */
    protected Object[] m_constants;
    /** The indices where constants are copied. */
    protected int[] m_indicesOfConstants;
    /** The current tuple. */
    protected Object[] m_currentTuple;

    /**
     * Creates an instance of this class.
     *
     * @param indicesToCopy                     the indices to copy
     * @param constants                         the constants to copy
     * @param indicesOfConstants                the indices to which constants are copied
     */
    public TupleRename(int[][] indicesToCopy,Object[] constants,int[] indicesOfConstants) {
        m_indicesToCopy=indicesToCopy;
        m_constants=constants;
        m_indicesOfConstants=indicesOfConstants;
    }
    /**
     * Creates the tuple from given input tuple.
     *
     * @param inputTuple                        the input tuple
     * @return                                  the resulting tuple
     */
    public Object[] renameTuple(Object[] inputTuple) {
        Object[] resultTuple=new Object[m_indicesToCopy.length+m_constants.length];
        for (int i=m_indicesToCopy.length-1;i>=0;--i)
            resultTuple[m_indicesToCopy[i][1]]=inputTuple[m_indicesToCopy[i][0]];
        for (int i=m_constants.length-1;i>=0;--i)
            resultTuple[m_indicesOfConstants[i]]=m_constants[i];
        return resultTuple;
    }
    /**
     * Creates the tuple from given input tuple.
     *
     * @param inputTuple                        the input tuple
     * @return                                  the resulting tuple
     */
    public Object[] renameTupleAddDisjunctionInfo(Object[] inputTuple) {
        Object[] resultTuple=new Object[m_indicesToCopy.length+m_constants.length+1];
        for (int i=m_indicesToCopy.length-1;i>=0;--i)
            resultTuple[m_indicesToCopy[i][1]]=inputTuple[m_indicesToCopy[i][0]];
        for (int i=m_constants.length-1;i>=0;--i)
            resultTuple[m_indicesOfConstants[i]]=m_constants[i];
        resultTuple[resultTuple.length-1]=new DisjunctionRestInfo(null);
        return resultTuple;
    }
}
