package edu.unika.aifb.kaon.datalog.evaluation;

/**
 * A query operator returning just one tuple.
 */
public class SingletonQueryOperator implements QueryOperator {
    /** The singleton tuple. */
    protected Object[] m_singletonTuple;
    /** Set to <code>true</code> if the the operator is pointing at the tuple. */
    protected boolean m_pointsToTuple;

    /**
     * Creates an instance of this class.
     *
     * @param singletonTuple            the tuple
     */
    public SingletonQueryOperator(Object[] singletonTuple) {
        m_singletonTuple=singletonTuple;
    }
    /**
     * Starts the processing of the query. The cursor is positioned on the first tuple, or at end.
     */
    public void start() {
        m_pointsToTuple=true;
    }
    /**
     * Stops the processing of the query.
     */
    public void stop() {
        m_pointsToTuple=false;
    }
    /**
     * Returns the current tuple of the operator. If the tuple stream is at the end, <code>null</code> is returned.
     *
     * @return                          the current tuple (or <code>null</code> if the tuple stream is at the end)
     */
    public Object[] tuple() {
        if (m_pointsToTuple)
            return m_singletonTuple;
        else
            return null;
    }
    /**
     * Returns <code>true</code> if the current stream is after the last tuple.
     *
     * @return                          <code>true</code> if the stream is after the last tuple
     */
    public boolean afterLast() {
        return !m_pointsToTuple;
    }
    /**
     * Moves the cursor to the next position. If the tuple stream is at the end this method call has no effect.
     */
    public void next() {
        m_pointsToTuple=false;
    }
}
