package edu.unika.aifb.kaon.datalog.evaluation;

import edu.unika.aifb.kaon.datalog.*;

/**
 * An evaluator of a sequence of evaluators.
 */
public class SequenceEvaluator implements Evaluator {
    /** The array of evaluators to execute. */
    protected Evaluator[] m_evaluators;

    /**
     * Creates an instance of this class.
     *
     * @param evaluators                    the array of evaluators
     */
    public SequenceEvaluator(Evaluator[] evaluators) {
        m_evaluators=evaluators;
    }
    /**
     * Executes this evaluator.
     *
     * @throws DatalogException             thrown if there is an error in evaluation
     */
    public void execute() throws DatalogException {
        for (int i=0;i<m_evaluators.length;i++)
            m_evaluators[i].execute();
    }
}
