package edu.unika.aifb.kaon.datalog.evaluation;

import edu.unika.aifb.kaon.datalog.*;

/**
 * An operator that implements a step in the query evaluation.
 */
public interface QueryOperator {
    /**
     * Starts the processing of the query. The cursor is positioned on the first tuple, or at end.
     *
     * @throws DatalogException         thrown if there is an error in evaluation
     */
    void start() throws DatalogException;
    /**
     * Stops the processing of the query.
     *
     * @throws DatalogException         thrown if there is an error in evaluation
     */
    void stop() throws DatalogException;
    /**
     * Returns the current tuple of the operator. If the tuple stream is at the end, <code>null</code> is returned.
     *
     * @return                          the current tuple (or <code>null</code> if the tuple stream is at the end)
     * @throws DatalogException         thrown if there is an error in evaluation
     */
    Object[] tuple() throws DatalogException;
    /**
     * Returns <code>true</code> if the current stream is after the last tuple.
     *
     * @return                          <code>true</code> if the stream is after the last tuple
     * @throws DatalogException         thrown if there is an error in evaluation
     */
    boolean afterLast() throws DatalogException;
    /**
     * Moves the cursor to the next position. If the tuple stream is at the end this method call has no effect.
     *
     * @throws DatalogException         thrown if there is an error in evaluation
     */
    void next() throws DatalogException;
}
