package edu.unika.aifb.kaon.datalog.evaluation;

import java.util.Iterator;

import edu.unika.aifb.kaon.datalog.*;
import edu.unika.aifb.kaon.datalog.program.*;

/**
 * Represents an extension of the predicate.
 */
public interface PredicateExtension {
    /**
     * Returns the predicate of the extension.
     *
     * @return                                      the predicate of this extension
     * @throws DatalogException                     thrown if there is an error
     */
    Predicate getPredicate() throws DatalogException;
    /**
     * Returns whether this predicate extension contains disjunctions.
     *
     * @return                                      <code>true</code> if this predicate extension contains disjunctions
     * @throws DatalogException                     thrown if there is an error
     */
    boolean getContainsDisjunctionInfo() throws DatalogException;
    /**
     * Selects the tuples with specified value at given position.
     *
     * @param values                                the values
     * @param positions                             the positions of the value
     * @return                                      the iterator of tuples matching the condition
     * @throws DatalogException                     thrown if there is an error with selecting data
     */
    Iterator selectTuples(Object[] values,int[] positions) throws DatalogException;
}
