package edu.unika.aifb.kaon.datalog.evaluation;

import java.util.Set;
import java.util.Map;
import java.util.HashMap;
import java.util.Iterator;

import edu.unika.aifb.kaon.datalog.program.*;

/**
 * Implements the in-memory version of the extensional database.
 */
public class MemoryExtensionalDatabase extends PredicateExtensionExtensionalDatabase {
    /** The extensional relations indexed by their predicates. */
    protected Map m_relationsByPredicate;

    /**
     * Creates an instance of this class.
     */
    public MemoryExtensionalDatabase() {
        m_relationsByPredicate=new HashMap();
    }
    /**
     * Clears all extensions of all predicates in the database.
     */
    public void clear() {
        Iterator iterator=m_relationsByPredicate.values().iterator();
        while (iterator.hasNext()) {
            MemoryPredicateExtension extension=(MemoryPredicateExtension)iterator.next();
            extension.clear();
        }
    }
    /**
     * Returns the extension for given predicate.
     *
     * @param predicate                     the predicate
     * @return                              the extension for the given predicate
     */
    public PredicateExtension getPredicateExtension(Predicate predicate) {
        return (PredicateExtension)m_relationsByPredicate.get(predicate);
    }
    /**
     * Returns the memory extension for given predicate.
     *
     * @param predicate                     the predicate
     * @return                              the memory extension for the given predicate
     */
    public MemoryPredicateExtension getMemoryPredicateExtension(Predicate predicate) {
        return (MemoryPredicateExtension)m_relationsByPredicate.get(predicate);
    }
    /**
     * Creates the extension for given predicate (if the extension already exists, it is not created again).
     *
     * @param predicate                     the predicate
     * @return                              the extension for the given predicate
     */
    public MemoryPredicateExtension createPredicateExtension(Predicate predicate) {
        MemoryPredicateExtension memoryPredicateExtension=(MemoryPredicateExtension)m_relationsByPredicate.get(predicate);
        if (memoryPredicateExtension==null) {
            memoryPredicateExtension=new MemoryPredicateExtension(predicate);
            m_relationsByPredicate.put(predicate,memoryPredicateExtension);
        }
        return memoryPredicateExtension;
    }
    /**
     * Removes the extension for given predicate.
     *
     * @param predicate                     the predicate
     */
    public void removePredicateExtension(Predicate predicate) {
        m_relationsByPredicate.remove(predicate);
    }
    /**
     * Returns the set of predicates that this database manages.
     *
     * @return                              the set of predicates that this database manages
     */
    public Set getPredicates() {
        return m_relationsByPredicate.keySet();
    }
}
