package edu.unika.aifb.kaon.datalog.evaluation;

import edu.unika.aifb.kaon.datalog.program.*;

/**
 * A literal value consisting of a predicate name and a tuple.
 */
public class LiteralValue {
    /** The predicate of this value. */
    protected Predicate m_predicate;
    /** The tuple of this value. */
    protected Object[] m_tuple;

    /**
     * Creates an instance of this class.
     *
     * @param predicate                     the predicate
     * @param tuple                         the tuple
     */
    public LiteralValue(Predicate predicate,Object[] tuple) {
        m_predicate=predicate;
        m_tuple=tuple;
    }
    /**
     * Returns the predicate.
     *
     * @return                              the predicate
     */
    public Predicate getPredicate() {
        return m_predicate;
    }
    /**
     * Returns the tuple.
     *
     * @return                              the tuple
     */
    public Object[] getTuple() {
        return m_tuple;
    }
    /**
     * Checks whether two literal values are equal.
     *
     * @param that                          the other literal vlaue
     * @return                              <code>true</code> if literal values are equal
     */
    public boolean equals(Object that) {
        if (this==that)
            return true;
        if (!(that instanceof LiteralValue))
            return false;
        LiteralValue thatLiteralValue=(LiteralValue)that;
        if (!m_predicate.equals(thatLiteralValue.m_predicate))
            return false;
        for (int i=m_tuple.length-1;i>=0;--i) {
            Object object1=m_tuple[i];
            Object object2=thatLiteralValue.m_tuple[i];
            if (object1!=object2 && (object1==null || !object1.equals(object2)))
                return false;
        }
        return true;
    }
    /**
     * Returns the hash-code of this object.
     *
     * @return                              the hash-code of this object
     */
    public int hashCode() {
        int hash=m_predicate.hashCode();
        for (int i=0;i<m_tuple.length;i++) {
            Object object=m_tuple[i];
            hash=hash*3+(object==null ? 0 : object.hashCode());
        }
        return hash;
    }
}
